/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Landslide: ImageVector
    get() {
        if (_landslide != null) {
            return _landslide!!
        }
        _landslide = materialIcon(name = "Sharp.Landslide") {
            materialPath {
                moveTo(15.47f, 13.79f)
                lineToRelative(-2.58f, -1.03f)
                lineToRelative(-6.89f, 2.29f)
                lineToRelative(-4.0f, -1.54f)
                lineToRelative(0.0f, 2.1f)
                lineToRelative(4.0f, 1.34f)
                close()
            }
            materialPath {
                moveTo(10.57f, 11.42f)
                lineToRelative(-2.57f, -3.42f)
                lineToRelative(-6.0f, 0.0f)
                lineToRelative(0.0f, 3.61f)
                lineToRelative(4.0f, 1.34f)
                close()
            }
            materialPath {
                moveTo(6.0f, 19.05f)
                lineToRelative(-4.0f, -1.33f)
                lineToRelative(0.0f, 4.28f)
                lineToRelative(20.0f, 0.0f)
                lineToRelative(-4.97f, -6.62f)
                close()
            }
            materialPath {
                moveTo(17.0f, 6.0f)
                lineToRelative(0.0f, -5.0f)
                lineToRelative(-5.0f, -1.0f)
                lineToRelative(-3.0f, 2.0f)
                lineToRelative(0.0f, 4.0f)
                lineToRelative(3.0f, 2.0f)
                close()
            }
            materialPath {
                moveTo(18.5f, 7.0f)
                lineToRelative(-2.5f, 2.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(2.5f, 2.0f)
                lineToRelative(4.5f, -2.0f)
                lineToRelative(0.0f, -4.0f)
                close()
            }
        }
        return _landslide!!
    }

private var _landslide: ImageVector? = null
