/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Light: ImageVector
    get() {
        if (_light != null) {
            return _light!!
        }
        _light = materialIcon(name = "Sharp.Light") {
            materialPath {
                moveTo(13.0f, 6.06f)
                verticalLineTo(3.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(3.06f)
                curveTo(5.87f, 6.63f, 2.03f, 11.51f, 3.22f, 17.0f)
                lineTo(8.0f, 17.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                reflectiveCurveToRelative(4.0f, -1.79f, 4.0f, -4.0f)
                lineToRelative(4.78f, 0.0f)
                curveTo(21.97f, 11.51f, 18.13f, 6.63f, 13.0f, 6.06f)
                close()
                moveTo(12.0f, 15.0f)
                horizontalLineTo(5.0f)
                curveToRelative(0.0f, -3.86f, 3.14f, -7.0f, 7.0f, -7.0f)
                reflectiveCurveToRelative(7.0f, 3.14f, 7.0f, 7.0f)
                horizontalLineTo(12.0f)
                close()
            }
        }
        return _light!!
    }

private var _light: ImageVector? = null
