/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.PianoOff: ImageVector
    get() {
        if (_pianoOff != null) {
            return _pianoOff!!
        }
        _pianoOff = materialIcon(name = "Sharp.PianoOff") {
            materialPath {
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(3.0f, 5.83f)
                verticalLineTo(21.0f)
                horizontalLineToRelative(15.17f)
                lineToRelative(1.61f, 1.61f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(8.25f, 19.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(7.83f)
                lineToRelative(2.0f, 2.0f)
                verticalLineToRelative(4.67f)
                horizontalLineToRelative(1.25f)
                verticalLineTo(19.0f)
                close()
                moveTo(9.75f, 19.0f)
                verticalLineToRelative(-4.5f)
                horizontalLineTo(11.0f)
                verticalLineToRelative(-0.67f)
                lineToRelative(3.25f, 3.25f)
                verticalLineTo(19.0f)
                horizontalLineTo(9.75f)
                close()
                moveTo(5.83f, 3.0f)
                horizontalLineTo(21.0f)
                verticalLineToRelative(15.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(9.17f)
                lineToRelative(-4.0f, -4.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(3.17f)
                lineTo(5.83f, 3.0f)
                close()
            }
        }
        return _pianoOff!!
    }

private var _pianoOff: ImageVector? = null
