/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Pinch: ImageVector
    get() {
        if (_pinch != null) {
            return _pinch!!
        }
        _pinch = materialIcon(name = "Sharp.Pinch") {
            materialPath {
                moveTo(23.18f, 15.4f)
                lineTo(22.1f, 23.0f)
                horizontalLineToRelative(-9.0f)
                lineTo(8.0f, 17.62f)
                lineToRelative(1.22f, -1.23f)
                lineTo(13.0f, 17.24f)
                verticalLineTo(6.5f)
                curveTo(13.0f, 5.67f, 13.67f, 5.0f, 14.5f, 5.0f)
                reflectiveCurveTo(16.0f, 5.67f, 16.0f, 6.5f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.38f)
                lineTo(23.18f, 15.4f)
                close()
                moveTo(6.0f, 2.5f)
                verticalLineTo(1.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(9.5f)
                verticalLineTo(3.56f)
                lineTo(3.56f, 9.5f)
                horizontalLineTo(6.0f)
                verticalLineTo(11.0f)
                horizontalLineTo(1.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(2.44f)
                lineTo(8.44f, 2.5f)
                horizontalLineTo(6.0f)
                close()
            }
        }
        return _pinch!!
    }

private var _pinch: ImageVector? = null
