/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Repartition: ImageVector
    get() {
        if (_repartition != null) {
            return _repartition!!
        }
        _repartition = materialIcon(name = "Sharp.Repartition") {
            materialPath {
                moveTo(3.0f, 21.0f)
                horizontalLineToRelative(18.0f)
                verticalLineToRelative(-6.0f)
                horizontalLineTo(3.0f)
                verticalLineTo(21.0f)
                close()
                moveTo(10.33f, 19.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.33f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(10.33f)
                close()
                moveTo(19.0f, 19.0f)
                horizontalLineToRelative(-3.33f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(19.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(5.0f, 17.0f)
                horizontalLineToRelative(3.33f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(5.0f)
                verticalLineTo(17.0f)
                close()
            }
            materialPath {
                moveTo(6.0f, 10.0f)
                lineToRelative(1.42f, -1.42f)
                lineTo(5.83f, 7.0f)
                horizontalLineTo(17.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                reflectiveCurveToRelative(-0.9f, 2.0f, -2.0f, 2.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(14.0f)
                curveToRelative(2.21f, 0.0f, 4.0f, -1.79f, 4.0f, -4.0f)
                reflectiveCurveToRelative(-1.79f, -4.0f, -4.0f, -4.0f)
                horizontalLineTo(5.83f)
                lineToRelative(1.59f, -1.59f)
                lineTo(6.0f, 2.0f)
                lineTo(2.0f, 6.0f)
                lineTo(6.0f, 10.0f)
                close()
            }
        }
        return _repartition!!
    }

private var _repartition: ImageVector? = null
