/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ScreenSearchDesktop: ImageVector
    get() {
        if (_screenSearchDesktop != null) {
            return _screenSearchDesktop!!
        }
        _screenSearchDesktop = materialIcon(name = "Sharp.ScreenSearchDesktop") {
            materialPath {
                moveTo(1.0f, 19.0f)
                horizontalLineToRelative(22.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-22.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 3.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(15.0f)
                horizontalLineToRelative(19.99f)
                lineTo(22.0f, 3.0f)
                close()
                moveTo(15.47f, 15.03f)
                lineToRelative(-2.09f, -2.09f)
                curveToRelative(-1.35f, 0.87f, -3.17f, 0.71f, -4.36f, -0.47f)
                curveToRelative(-1.37f, -1.37f, -1.37f, -3.58f, 0.0f, -4.95f)
                reflectiveCurveToRelative(3.58f, -1.37f, 4.95f, 0.0f)
                curveToRelative(1.18f, 1.18f, 1.34f, 3.0f, 0.47f, 4.36f)
                lineToRelative(2.09f, 2.09f)
                lineTo(15.47f, 15.03f)
                close()
            }
            materialPath {
                moveTo(11.5f, 10.0f)
                moveToRelative(-2.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, 4.0f, 0.0f)
                arcToRelative(2.0f, 2.0f, 0.0f, true, true, -4.0f, 0.0f)
            }
        }
        return _screenSearchDesktop!!
    }

private var _screenSearchDesktop: ImageVector? = null
