/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SettingsInputSvideo: ImageVector
    get() {
        if (_settingsInputSvideo != null) {
            return _settingsInputSvideo!!
        }
        _settingsInputSvideo = materialIcon(name = "Sharp.SettingsInputSvideo") {
            materialPath {
                moveTo(8.0f, 11.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                reflectiveCurveTo(5.0f, 10.67f, 5.0f, 11.5f)
                reflectiveCurveTo(5.67f, 13.0f, 6.5f, 13.0f)
                reflectiveCurveTo(8.0f, 12.33f, 8.0f, 11.5f)
                close()
                moveTo(15.0f, 6.5f)
                curveToRelative(0.0f, -0.83f, -0.67f, -1.5f, -1.5f, -1.5f)
                horizontalLineToRelative(-3.0f)
                curveTo(9.67f, 5.0f, 9.0f, 5.67f, 9.0f, 6.5f)
                reflectiveCurveTo(9.67f, 8.0f, 10.5f, 8.0f)
                horizontalLineToRelative(3.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, -0.67f, 1.5f, -1.5f)
                close()
                moveTo(8.5f, 15.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, 0.67f, -1.5f, 1.5f)
                reflectiveCurveTo(7.67f, 18.0f, 8.5f, 18.0f)
                reflectiveCurveToRelative(1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveTo(9.33f, 15.0f, 8.5f, 15.0f)
                close()
                moveTo(12.0f, 1.0f)
                curveTo(5.93f, 1.0f, 1.0f, 5.93f, 1.0f, 12.0f)
                reflectiveCurveToRelative(4.93f, 11.0f, 11.0f, 11.0f)
                reflectiveCurveToRelative(11.0f, -4.93f, 11.0f, -11.0f)
                reflectiveCurveTo(18.07f, 1.0f, 12.0f, 1.0f)
                close()
                moveTo(12.0f, 21.0f)
                curveToRelative(-4.96f, 0.0f, -9.0f, -4.04f, -9.0f, -9.0f)
                reflectiveCurveToRelative(4.04f, -9.0f, 9.0f, -9.0f)
                reflectiveCurveToRelative(9.0f, 4.04f, 9.0f, 9.0f)
                reflectiveCurveToRelative(-4.04f, 9.0f, -9.0f, 9.0f)
                close()
                moveTo(17.5f, 10.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, 0.67f, -1.5f, 1.5f)
                reflectiveCurveToRelative(0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveToRelative(1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveToRelative(-0.67f, -1.5f, -1.5f, -1.5f)
                close()
                moveTo(15.5f, 15.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, 0.67f, -1.5f, 1.5f)
                reflectiveCurveToRelative(0.67f, 1.5f, 1.5f, 1.5f)
                reflectiveCurveToRelative(1.5f, -0.67f, 1.5f, -1.5f)
                reflectiveCurveToRelative(-0.67f, -1.5f, -1.5f, -1.5f)
                close()
            }
        }
        return _settingsInputSvideo!!
    }

private var _settingsInputSvideo: ImageVector? = null
