/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SignLanguage: ImageVector
    get() {
        if (_signLanguage != null) {
            return _signLanguage!!
        }
        _signLanguage = materialIcon(name = "Sharp.SignLanguage") {
            materialPath {
                moveTo(12.49f, 13.0f)
                lineToRelative(-1.39f, -2.7f)
                lineTo(12.49f, 9.0f)
                lineTo(19.0f, 15.2f)
                verticalLineTo(24.0f)
                horizontalLineTo(4.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(10.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(3.5f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(12.49f)
                close()
                moveTo(11.78f, 7.12f)
                curveToRelative(-0.84f, 0.4f, -1.17f, 0.62f, -1.63f, 1.19f)
                lineTo(6.76f, 4.74f)
                lineToRelative(1.45f, -1.38f)
                lineTo(11.78f, 7.12f)
                close()
                moveTo(9.64f, 9.21f)
                curveTo(9.41f, 9.76f, 9.35f, 10.45f, 9.44f, 11.0f)
                horizontalLineTo(8.58f)
                lineTo(5.62f, 7.89f)
                lineToRelative(1.45f, -1.38f)
                lineTo(9.64f, 9.21f)
                close()
                moveTo(21.98f, 12.34f)
                lineTo(22.0f, 3.35f)
                lineToRelative(-1.9f, -0.1f)
                lineToRelative(-1.0f, 2.86f)
                lineTo(13.3f, 0.0f)
                lineToRelative(-1.45f, 1.38f)
                lineToRelative(4.09f, 4.3f)
                lineToRelative(-0.73f, 0.69f)
                lineTo(9.74f, 0.64f)
                lineTo(8.3f, 2.0f)
                lineToRelative(3.36f, 3.53f)
                lineToRelative(1.06f, 1.11f)
                lineToRelative(2.65f, 2.33f)
                lineToRelative(5.08f, 4.83f)
                lineTo(21.98f, 12.34f)
                close()
            }
        }
        return _signLanguage!!
    }

private var _signLanguage: ImageVector? = null
