/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SwipeDownAlt: ImageVector
    get() {
        if (_swipeDownAlt != null) {
            return _swipeDownAlt!!
        }
        _swipeDownAlt = materialIcon(name = "Sharp.SwipeDownAlt") {
            materialPath {
                moveTo(13.0f, 13.9f)
                curveToRelative(2.28f, -0.46f, 4.0f, -2.48f, 4.0f, -4.9f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                reflectiveCurveTo(7.0f, 6.24f, 7.0f, 9.0f)
                curveToRelative(0.0f, 2.42f, 1.72f, 4.44f, 4.0f, 4.9f)
                verticalLineToRelative(4.27f)
                lineToRelative(-1.59f, -1.59f)
                lineTo(8.0f, 18.0f)
                lineToRelative(4.0f, 4.0f)
                lineToRelative(4.0f, -4.0f)
                lineToRelative(-1.41f, -1.41f)
                lineTo(13.0f, 18.17f)
                verticalLineTo(13.9f)
                close()
            }
        }
        return _swipeDownAlt!!
    }

private var _swipeDownAlt: ImageVector? = null
