/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.TableChart: ImageVector
    get() {
        if (_tableChart != null) {
            return _tableChart!!
        }
        _tableChart = materialIcon(name = "Sharp.TableChart") {
            materialPath {
                moveTo(10.0f, 10.02f)
                horizontalLineToRelative(5.0f)
                lineTo(15.0f, 21.0f)
                horizontalLineToRelative(-5.0f)
                lineTo(10.0f, 10.02f)
                close()
                moveTo(17.0f, 21.0f)
                horizontalLineToRelative(5.0f)
                lineTo(22.0f, 10.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineToRelative(11.0f)
                close()
                moveTo(22.0f, 3.0f)
                lineTo(3.0f, 3.0f)
                verticalLineToRelative(5.0f)
                horizontalLineToRelative(19.0f)
                lineTo(22.0f, 3.0f)
                close()
                moveTo(3.0f, 21.0f)
                horizontalLineToRelative(5.0f)
                lineTo(8.0f, 10.0f)
                lineTo(3.0f, 10.0f)
                verticalLineToRelative(11.0f)
                close()
            }
        }
        return _tableChart!!
    }

private var _tableChart: ImageVector? = null
