/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VideogameAssetOff: ImageVector
    get() {
        if (_videogameAssetOff != null) {
            return _videogameAssetOff!!
        }
        _videogameAssetOff = materialIcon(name = "Sharp.VideogameAssetOff") {
            materialPath {
                moveTo(20.83f, 18.0f)
                horizontalLineTo(22.0f)
                verticalLineTo(6.0f)
                horizontalLineTo(8.83f)
                lineTo(20.83f, 18.0f)
                close()
                moveTo(17.5f, 9.0f)
                curveToRelative(0.83f, 0.0f, 1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(18.33f, 12.0f, 17.5f, 12.0f)
                reflectiveCurveTo(16.0f, 11.33f, 16.0f, 10.5f)
                reflectiveCurveTo(16.67f, 9.0f, 17.5f, 9.0f)
                close()
                moveTo(21.19f, 21.19f)
                lineTo(2.81f, 2.81f)
                lineTo(1.39f, 4.22f)
                lineTo(3.17f, 6.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(13.17f)
                lineToRelative(4.61f, 4.61f)
                lineTo(21.19f, 21.19f)
                close()
                moveTo(9.0f, 13.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(5.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(9.83f)
                lineTo(10.17f, 13.0f)
                horizontalLineTo(9.0f)
                close()
            }
        }
        return _videogameAssetOff!!
    }

private var _videogameAssetOff: ImageVector? = null
