/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.ViewInAr: ImageVector
    get() {
        if (_viewInAr != null) {
            return _viewInAr!!
        }
        _viewInAr = materialIcon(name = "Sharp.ViewInAr") {
            materialPath {
                moveTo(18.0f, 1.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -5.0f)
                close()
            }
            materialPath {
                moveTo(21.0f, 21.0f)
                lineToRelative(-3.0f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(0.0f, -5.0f)
                lineToRelative(-2.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 3.0f)
                lineToRelative(3.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-5.0f, 0.0f)
                lineToRelative(0.0f, 5.0f)
                lineToRelative(2.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 18.0f)
                lineToRelative(-2.0f, 0.0f)
                lineToRelative(0.0f, 5.0f)
                lineToRelative(5.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-3.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 7.97f)
                lineToRelative(-7.0f, -4.03f)
                lineTo(5.0f, 7.97f)
                verticalLineToRelative(8.06f)
                lineToRelative(7.0f, 4.03f)
                lineToRelative(7.0f, -4.03f)
                verticalLineTo(7.97f)
                close()
                moveTo(11.0f, 17.17f)
                lineToRelative(-4.0f, -2.3f)
                verticalLineToRelative(-4.63f)
                lineToRelative(4.0f, 2.33f)
                verticalLineTo(17.17f)
                close()
                moveTo(12.0f, 10.84f)
                lineTo(8.04f, 8.53f)
                lineTo(12.0f, 6.25f)
                lineToRelative(3.96f, 2.28f)
                lineTo(12.0f, 10.84f)
                close()
                moveTo(17.0f, 14.87f)
                lineToRelative(-4.0f, 2.3f)
                verticalLineToRelative(-4.6f)
                lineToRelative(4.0f, -2.33f)
                verticalLineTo(14.87f)
                close()
            }
        }
        return _viewInAr!!
    }

private var _viewInAr: ImageVector? = null
