/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.CarRepair: ImageVector
    get() {
        if (_carRepair != null) {
            return _carRepair!!
        }
        _carRepair = materialIcon(name = "TwoTone.CarRepair") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.0f, 9.01f)
                verticalLineTo(9.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(0.01f)
                verticalLineTo(12.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(9.01f)
                close()
                moveTo(9.0f, 11.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(9.55f, 11.5f, 9.0f, 11.5f)
                close()
                moveTo(15.0f, 11.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(15.55f, 11.5f, 15.0f, 11.5f)
                close()
            }
            materialPath {
                moveTo(9.0f, 10.5f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(15.0f, 10.5f)
                moveToRelative(-1.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, 2.0f, 0.0f)
                arcToRelative(1.0f, 1.0f, 0.0f, true, true, -2.0f, 0.0f)
            }
            materialPath {
                moveTo(5.78f, 16.0f)
                horizontalLineToRelative(0.44f)
                curveTo(6.65f, 16.0f, 7.0f, 15.64f, 7.0f, 15.19f)
                verticalLineTo(14.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(1.19f)
                curveToRelative(0.0f, 0.45f, 0.34f, 0.81f, 0.78f, 0.81f)
                horizontalLineToRelative(0.44f)
                curveToRelative(0.43f, 0.0f, 0.78f, -0.36f, 0.78f, -0.81f)
                verticalLineToRelative(-6.5f)
                curveToRelative(0.0f, 0.0f, -1.34f, -4.03f, -1.56f, -4.69f)
                curveToRelative(-0.05f, -0.16f, -0.12f, -0.29f, -0.19f, -0.4f)
                curveToRelative(-0.02f, -0.02f, -0.03f, -0.04f, -0.05f, -0.07f)
                curveTo(16.82f, 3.01f, 16.28f, 3.0f, 16.28f, 3.0f)
                horizontalLineTo(7.72f)
                curveToRelative(0.0f, 0.0f, -0.54f, 0.01f, -0.92f, 0.54f)
                curveTo(6.78f, 3.56f, 6.77f, 3.58f, 6.75f, 3.6f)
                curveTo(6.68f, 3.71f, 6.61f, 3.84f, 6.56f, 4.0f)
                curveTo(6.34f, 4.66f, 5.0f, 8.69f, 5.0f, 8.69f)
                verticalLineToRelative(6.5f)
                curveTo(5.0f, 15.64f, 5.35f, 16.0f, 5.78f, 16.0f)
                close()
                moveTo(8.33f, 5.0f)
                horizontalLineToRelative(7.34f)
                lineToRelative(0.23f, 0.69f)
                lineTo(16.33f, 7.0f)
                horizontalLineTo(7.67f)
                lineTo(8.33f, 5.0f)
                close()
                moveTo(7.0f, 9.01f)
                verticalLineTo(9.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(0.01f)
                verticalLineTo(12.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(9.01f)
                close()
            }
            materialPath {
                moveTo(4.0f, 17.01f)
                lineToRelative(0.0f, 1.99f)
                lineToRelative(7.0f, 0.0f)
                lineToRelative(0.0f, 3.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -3.0f)
                lineToRelative(7.0f, 0.0f)
                lineToRelative(0.0f, -1.99f)
                close()
            }
        }
        return _carRepair!!
    }

private var _carRepair: ImageVector? = null
