/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Factory: ImageVector
    get() {
        if (_factory != null) {
            return _factory!!
        }
        _factory = materialIcon(name = "TwoTone.Factory") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 12.0f)
                lineToRelative(0.0f, -2.05f)
                lineToRelative(-5.0f, 2.0f)
                verticalLineTo(10.0f)
                lineToRelative(-3.0f, 1.32f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineTo(12.0f)
                close()
                moveTo(9.0f, 18.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(13.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(17.0f, 18.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(18.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 22.0f)
                horizontalLineTo(2.0f)
                verticalLineTo(10.0f)
                lineToRelative(7.0f, -3.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(5.0f, -2.0f)
                lineToRelative(0.0f, 3.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(1.0f, -8.0f)
                horizontalLineToRelative(3.0f)
                lineToRelative(1.0f, 8.0f)
                verticalLineTo(22.0f)
                close()
                moveTo(12.0f, 9.95f)
                lineToRelative(-5.0f, 2.0f)
                verticalLineTo(10.0f)
                lineToRelative(-3.0f, 1.32f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(16.0f)
                verticalLineToRelative(-8.0f)
                horizontalLineToRelative(-8.0f)
                lineTo(12.0f, 9.95f)
                close()
                moveTo(11.0f, 18.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(7.0f, 18.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(18.0f)
                close()
                moveTo(17.0f, 14.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(14.0f)
                close()
            }
        }
        return _factory!!
    }

private var _factory: ImageVector? = null
