/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.FlagCircle: ImageVector
    get() {
        if (_flagCircle != null) {
            return _flagCircle!!
        }
        _flagCircle = materialIcon(name = "TwoTone.FlagCircle") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.0f, 4.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, 3.59f, -8.0f, 8.0f)
                reflectiveCurveToRelative(3.59f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.59f, 8.0f, -8.0f)
                reflectiveCurveTo(16.41f, 4.0f, 12.0f, 4.0f)
                close()
                moveTo(13.0f, 15.0f)
                lineToRelative(-1.0f, -2.0f)
                horizontalLineTo(9.5f)
                verticalLineToRelative(5.0f)
                horizontalLineTo(8.0f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(6.0f)
                lineToRelative(1.0f, 2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(6.0f)
                horizontalLineTo(13.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                reflectiveCurveTo(17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.41f, 0.0f, -8.0f, -3.59f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.59f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.59f, 8.0f, 8.0f)
                reflectiveCurveTo(16.41f, 20.0f, 12.0f, 20.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 9.0f)
                lineToRelative(-1.0f, -2.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-5.0f)
                horizontalLineTo(12.0f)
                lineToRelative(1.0f, 2.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(9.0f)
                horizontalLineTo(15.0f)
                close()
                moveTo(16.5f, 13.5f)
                horizontalLineToRelative(-2.57f)
                lineToRelative(-1.0f, -2.0f)
                horizontalLineTo(9.5f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(3.57f)
                lineToRelative(1.0f, 2.0f)
                horizontalLineToRelative(2.43f)
                verticalLineTo(13.5f)
                close()
            }
        }
        return _flagCircle!!
    }

private var _flagCircle: ImageVector? = null
