/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.Hexagon: ImageVector
    get() {
        if (_hexagon != null) {
            return _hexagon!!
        }
        _hexagon = materialIcon(name = "TwoTone.Hexagon") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.05f, 19.0f)
                lineToRelative(-8.1f, 0.0f)
                lineToRelative(-4.04f, -7.0f)
                lineToRelative(4.04f, -7.0f)
                lineToRelative(8.1f, 0.0f)
                lineToRelative(4.04f, 7.0f)
                close()
            }
            materialPath {
                moveTo(17.2f, 3.0f)
                horizontalLineTo(6.8f)
                lineToRelative(-5.2f, 9.0f)
                lineToRelative(5.2f, 9.0f)
                horizontalLineToRelative(10.4f)
                lineToRelative(5.2f, -9.0f)
                lineTo(17.2f, 3.0f)
                close()
                moveTo(16.05f, 19.0f)
                horizontalLineTo(7.95f)
                lineToRelative(-4.04f, -7.0f)
                lineToRelative(4.04f, -7.0f)
                horizontalLineToRelative(8.09f)
                lineToRelative(4.04f, 7.0f)
                lineTo(16.05f, 19.0f)
                close()
            }
        }
        return _hexagon!!
    }

private var _hexagon: ImageVector? = null
