/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.HowToVote: ImageVector
    get() {
        if (_howToVote != null) {
            return _howToVote!!
        }
        _howToVote = materialIcon(name = "TwoTone.HowToVote") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.0f, 19.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(5.0f)
                close()
            }
            materialPath {
                moveTo(18.0f, 13.0f)
                horizontalLineToRelative(-0.68f)
                lineToRelative(-2.0f, 2.0f)
                horizontalLineToRelative(1.91f)
                lineTo(19.0f, 17.0f)
                lineTo(5.0f, 17.0f)
                lineToRelative(1.78f, -2.0f)
                horizontalLineToRelative(2.05f)
                lineToRelative(-2.0f, -2.0f)
                lineTo(6.0f, 13.0f)
                lineToRelative(-3.0f, 3.0f)
                verticalLineToRelative(4.0f)
                curveToRelative(0.0f, 1.1f, 0.89f, 2.0f, 1.99f, 2.0f)
                lineTo(19.0f, 22.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.89f, 2.0f, -2.0f)
                verticalLineToRelative(-4.0f)
                lineToRelative(-3.0f, -3.0f)
                close()
                moveTo(19.0f, 20.0f)
                lineTo(5.0f, 20.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(14.0f)
                verticalLineToRelative(1.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(12.048f, 12.905f)
                lineTo(8.505f, 9.362f)
                lineToRelative(4.95f, -4.95f)
                lineToRelative(3.543f, 3.543f)
                close()
            }
            materialPath {
                moveTo(19.11f, 7.25f)
                lineTo(14.16f, 2.3f)
                curveToRelative(-0.38f, -0.4f, -1.01f, -0.4f, -1.4f, -0.01f)
                lineTo(6.39f, 8.66f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(4.95f, 4.95f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                lineToRelative(6.36f, -6.36f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                close()
                moveTo(12.05f, 12.9f)
                lineTo(8.51f, 9.36f)
                lineToRelative(4.95f, -4.95f)
                lineTo(17.0f, 7.95f)
                lineToRelative(-4.95f, 4.95f)
                close()
            }
        }
        return _howToVote!!
    }

private var _howToVote: ImageVector? = null
