/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.NoPhotography: ImageVector
    get() {
        if (_noPhotography != null) {
            return _noPhotography!!
        }
        _noPhotography = materialIcon(name = "TwoTone.NoPhotography") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(10.94f, 8.12f)
                lineTo(8.9f, 6.07f)
                lineTo(9.88f, 5.0f)
                horizontalLineToRelative(4.24f)
                lineToRelative(1.83f, 2.0f)
                horizontalLineTo(20.0f)
                verticalLineToRelative(10.17f)
                lineToRelative(-3.12f, -3.12f)
                curveTo(16.96f, 13.71f, 17.0f, 13.36f, 17.0f, 13.0f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                curveTo(11.64f, 8.0f, 11.29f, 8.04f, 10.94f, 8.12f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                curveToRelative(0.0f, -0.91f, 0.25f, -1.76f, 0.68f, -2.49f)
                lineTo(4.17f, 7.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineToRelative(12.17f)
                lineToRelative(-1.68f, -1.68f)
                curveTo(13.76f, 17.75f, 12.91f, 18.0f, 12.0f, 18.0f)
                close()
            }
            materialPath {
                moveTo(8.9f, 6.07f)
                lineTo(7.48f, 4.66f)
                lineTo(9.0f, 3.0f)
                horizontalLineToRelative(6.0f)
                lineToRelative(1.83f, 2.0f)
                horizontalLineTo(20.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 0.05f, -0.01f, 0.1f, -0.02f, 0.16f)
                lineTo(20.0f, 17.17f)
                verticalLineTo(7.0f)
                horizontalLineToRelative(-4.05f)
                lineToRelative(-1.83f, -2.0f)
                horizontalLineTo(9.88f)
                lineTo(8.9f, 6.07f)
                close()
                moveTo(20.49f, 23.31f)
                lineTo(18.17f, 21.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -0.59f, 0.27f, -1.12f, 0.68f, -1.49f)
                lineToRelative(-2.0f, -2.0f)
                lineTo(2.1f, 2.1f)
                lineTo(7.0f, 7.0f)
                lineToRelative(2.01f, 2.01f)
                lineToRelative(1.43f, 1.43f)
                lineToRelative(4.1f, 4.1f)
                lineToRelative(1.43f, 1.43f)
                lineTo(19.0f, 19.0f)
                lineToRelative(1.82f, 1.82f)
                lineToRelative(1.08f, 1.08f)
                lineTo(20.49f, 23.31f)
                close()
                moveTo(9.19f, 12.02f)
                curveTo(9.08f, 12.33f, 9.0f, 12.65f, 9.0f, 13.0f)
                curveToRelative(0.0f, 1.65f, 1.35f, 3.0f, 3.0f, 3.0f)
                curveToRelative(0.35f, 0.0f, 0.67f, -0.08f, 0.98f, -0.19f)
                lineTo(9.19f, 12.02f)
                close()
                moveTo(16.17f, 19.0f)
                lineToRelative(-1.68f, -1.68f)
                curveTo(13.76f, 17.75f, 12.91f, 18.0f, 12.0f, 18.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                curveToRelative(0.0f, -0.91f, 0.25f, -1.76f, 0.68f, -2.49f)
                lineTo(4.17f, 7.0f)
                horizontalLineTo(4.0f)
                verticalLineToRelative(12.0f)
                horizontalLineTo(16.17f)
                close()
                moveTo(14.81f, 11.98f)
                lineToRelative(2.08f, 2.08f)
                curveTo(16.96f, 13.71f, 17.0f, 13.36f, 17.0f, 13.0f)
                curveToRelative(0.0f, -2.76f, -2.24f, -5.0f, -5.0f, -5.0f)
                curveToRelative(-0.36f, 0.0f, -0.71f, 0.04f, -1.06f, 0.12f)
                lineToRelative(2.08f, 2.08f)
                curveTo(13.85f, 10.5f, 14.5f, 11.15f, 14.81f, 11.98f)
                close()
            }
        }
        return _noPhotography!!
    }

private var _noPhotography: ImageVector? = null
