/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.PointOfSale: ImageVector
    get() {
        if (_pointOfSale != null) {
            return _pointOfSale!!
        }
        _pointOfSale = materialIcon(name = "TwoTone.PointOfSale") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(9.5f, 16.0f)
                horizontalLineToRelative(-1.0f)
                curveTo(8.22f, 16.0f, 8.0f, 15.78f, 8.0f, 15.5f)
                curveTo(8.0f, 15.22f, 8.22f, 15.0f, 8.5f, 15.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(10.0f, 15.78f, 9.78f, 16.0f, 9.5f, 16.0f)
                close()
                moveTo(10.0f, 13.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveTo(8.22f, 13.0f, 8.0f, 13.22f, 8.0f, 13.5f)
                curveTo(8.0f, 13.78f, 8.22f, 14.0f, 8.5f, 14.0f)
                horizontalLineToRelative(1.0f)
                curveTo(9.78f, 14.0f, 10.0f, 13.78f, 10.0f, 13.5f)
                close()
                moveTo(10.0f, 11.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveTo(8.22f, 11.0f, 8.0f, 11.22f, 8.0f, 11.5f)
                curveTo(8.0f, 11.78f, 8.22f, 12.0f, 8.5f, 12.0f)
                horizontalLineToRelative(1.0f)
                curveTo(9.78f, 12.0f, 10.0f, 11.78f, 10.0f, 11.5f)
                close()
                moveTo(13.0f, 15.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineToRelative(1.0f)
                curveTo(12.78f, 16.0f, 13.0f, 15.78f, 13.0f, 15.5f)
                close()
                moveTo(13.0f, 13.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineToRelative(1.0f)
                curveTo(12.78f, 14.0f, 13.0f, 13.78f, 13.0f, 13.5f)
                close()
                moveTo(13.0f, 11.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineToRelative(1.0f)
                curveTo(12.78f, 12.0f, 13.0f, 11.78f, 13.0f, 11.5f)
                close()
                moveTo(16.0f, 15.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineToRelative(1.0f)
                curveTo(15.78f, 16.0f, 16.0f, 15.78f, 16.0f, 15.5f)
                close()
                moveTo(16.0f, 13.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineToRelative(1.0f)
                curveTo(15.78f, 14.0f, 16.0f, 13.78f, 16.0f, 13.5f)
                close()
                moveTo(16.0f, 11.5f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, 0.22f, -0.5f, 0.5f)
                curveToRelative(0.0f, 0.28f, 0.22f, 0.5f, 0.5f, 0.5f)
                horizontalLineToRelative(1.0f)
                curveTo(15.78f, 12.0f, 16.0f, 11.78f, 16.0f, 11.5f)
                close()
                moveTo(17.0f, 4.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(4.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 2.0f)
                horizontalLineTo(7.0f)
                curveTo(5.9f, 2.0f, 5.0f, 2.9f, 5.0f, 4.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(10.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                verticalLineTo(4.0f)
                curveTo(19.0f, 2.9f, 18.1f, 2.0f, 17.0f, 2.0f)
                close()
                moveTo(17.0f, 6.0f)
                horizontalLineTo(7.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(10.0f)
                verticalLineTo(6.0f)
                close()
                moveTo(20.0f, 22.0f)
                horizontalLineTo(4.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(20.0f)
                verticalLineToRelative(1.0f)
                curveTo(22.0f, 21.1f, 21.1f, 22.0f, 20.0f, 22.0f)
                close()
                moveTo(18.53f, 10.19f)
                curveTo(18.21f, 9.47f, 17.49f, 9.0f, 16.7f, 9.0f)
                horizontalLineTo(7.3f)
                curveToRelative(-0.79f, 0.0f, -1.51f, 0.47f, -1.83f, 1.19f)
                lineTo(2.0f, 18.0f)
                horizontalLineToRelative(20.0f)
                lineTo(18.53f, 10.19f)
                close()
                moveTo(9.5f, 16.0f)
                horizontalLineToRelative(-1.0f)
                curveTo(8.22f, 16.0f, 8.0f, 15.78f, 8.0f, 15.5f)
                curveTo(8.0f, 15.22f, 8.22f, 15.0f, 8.5f, 15.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(10.0f, 15.78f, 9.78f, 16.0f, 9.5f, 16.0f)
                close()
                moveTo(9.5f, 14.0f)
                horizontalLineToRelative(-1.0f)
                curveTo(8.22f, 14.0f, 8.0f, 13.78f, 8.0f, 13.5f)
                curveTo(8.0f, 13.22f, 8.22f, 13.0f, 8.5f, 13.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(10.0f, 13.78f, 9.78f, 14.0f, 9.5f, 14.0f)
                close()
                moveTo(9.5f, 12.0f)
                horizontalLineToRelative(-1.0f)
                curveTo(8.22f, 12.0f, 8.0f, 11.78f, 8.0f, 11.5f)
                curveTo(8.0f, 11.22f, 8.22f, 11.0f, 8.5f, 11.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(10.0f, 11.78f, 9.78f, 12.0f, 9.5f, 12.0f)
                close()
                moveTo(12.5f, 16.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(13.0f, 15.78f, 12.78f, 16.0f, 12.5f, 16.0f)
                close()
                moveTo(12.5f, 14.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(13.0f, 13.78f, 12.78f, 14.0f, 12.5f, 14.0f)
                close()
                moveTo(12.5f, 12.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(13.0f, 11.78f, 12.78f, 12.0f, 12.5f, 12.0f)
                close()
                moveTo(15.5f, 16.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(16.0f, 15.78f, 15.78f, 16.0f, 15.5f, 16.0f)
                close()
                moveTo(15.5f, 14.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(16.0f, 13.78f, 15.78f, 14.0f, 15.5f, 14.0f)
                close()
                moveTo(15.5f, 12.0f)
                horizontalLineToRelative(-1.0f)
                curveToRelative(-0.28f, 0.0f, -0.5f, -0.22f, -0.5f, -0.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                curveTo(16.0f, 11.78f, 15.78f, 12.0f, 15.5f, 12.0f)
                close()
            }
        }
        return _pointOfSale!!
    }

private var _pointOfSale: ImageVector? = null
