/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SportsBasketball: ImageVector
    get() {
        if (_sportsBasketball != null) {
            return _sportsBasketball!!
        }
        _sportsBasketball = materialIcon(name = "TwoTone.SportsBasketball") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(8.93f, 11.0f)
                horizontalLineTo(11.0f)
                verticalLineTo(4.07f)
                curveTo(9.27f, 4.29f, 7.71f, 5.06f, 6.5f, 6.2f)
                curveTo(7.81f, 7.44f, 8.69f, 9.12f, 8.93f, 11.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.93f, 11.0f)
                curveToRelative(-0.15f, -1.18f, -0.56f, -2.28f, -1.16f, -3.25f)
                curveTo(17.9f, 8.62f, 17.3f, 9.74f, 17.09f, 11.0f)
                horizontalLineTo(19.93f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(5.23f, 7.75f)
                curveTo(4.63f, 8.72f, 4.22f, 9.82f, 4.07f, 11.0f)
                horizontalLineToRelative(2.84f)
                curveTo(6.7f, 9.74f, 6.1f, 8.62f, 5.23f, 7.75f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(4.07f, 13.0f)
                curveToRelative(0.15f, 1.18f, 0.56f, 2.28f, 1.16f, 3.25f)
                curveTo(6.1f, 15.38f, 6.7f, 14.26f, 6.91f, 13.0f)
                horizontalLineTo(4.07f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.51f, 17.79f)
                curveToRelative(1.2f, 1.14f, 2.76f, 1.92f, 4.49f, 2.14f)
                verticalLineTo(13.0f)
                horizontalLineTo(8.93f)
                curveTo(8.7f, 14.88f, 7.81f, 16.55f, 6.51f, 17.79f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(17.5f, 6.2f)
                curveToRelative(-1.21f, -1.14f, -2.77f, -1.92f, -4.5f, -2.13f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(2.07f)
                curveTo(15.31f, 9.12f, 16.19f, 7.44f, 17.5f, 6.2f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(18.77f, 16.25f)
                curveToRelative(0.61f, -0.96f, 1.02f, -2.07f, 1.16f, -3.25f)
                horizontalLineToRelative(-2.84f)
                curveTo(17.3f, 14.26f, 17.9f, 15.38f, 18.77f, 16.25f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(13.0f, 13.0f)
                verticalLineToRelative(6.93f)
                curveToRelative(1.73f, -0.22f, 3.29f, -1.0f, 4.49f, -2.14f)
                curveToRelative(-1.3f, -1.24f, -2.19f, -2.91f, -2.42f, -4.79f)
                horizontalLineTo(13.0f)
                close()
            }
            materialPath {
                moveTo(12.0f, 2.0f)
                curveTo(6.48f, 2.0f, 2.0f, 6.48f, 2.0f, 12.0f)
                curveToRelative(0.0f, 5.52f, 4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                curveTo(22.0f, 6.48f, 17.52f, 2.0f, 12.0f, 2.0f)
                close()
                moveTo(5.23f, 7.75f)
                curveTo(6.1f, 8.62f, 6.7f, 9.74f, 6.91f, 11.0f)
                horizontalLineTo(4.07f)
                curveTo(4.22f, 9.82f, 4.63f, 8.72f, 5.23f, 7.75f)
                close()
                moveTo(4.07f, 13.0f)
                horizontalLineToRelative(2.84f)
                curveToRelative(-0.21f, 1.26f, -0.81f, 2.38f, -1.68f, 3.25f)
                curveTo(4.63f, 15.28f, 4.22f, 14.18f, 4.07f, 13.0f)
                close()
                moveTo(11.0f, 19.93f)
                curveToRelative(-1.73f, -0.22f, -3.29f, -1.0f, -4.49f, -2.14f)
                curveToRelative(1.3f, -1.24f, 2.19f, -2.91f, 2.42f, -4.79f)
                horizontalLineTo(11.0f)
                verticalLineTo(19.93f)
                close()
                moveTo(11.0f, 11.0f)
                horizontalLineTo(8.93f)
                curveTo(8.69f, 9.12f, 7.81f, 7.44f, 6.5f, 6.2f)
                curveTo(7.71f, 5.06f, 9.27f, 4.29f, 11.0f, 4.07f)
                verticalLineTo(11.0f)
                close()
                moveTo(19.93f, 11.0f)
                horizontalLineToRelative(-2.84f)
                curveToRelative(0.21f, -1.26f, 0.81f, -2.38f, 1.68f, -3.25f)
                curveTo(19.37f, 8.72f, 19.78f, 9.82f, 19.93f, 11.0f)
                close()
                moveTo(13.0f, 4.07f)
                curveToRelative(1.73f, 0.22f, 3.29f, 0.99f, 4.5f, 2.13f)
                curveToRelative(-1.31f, 1.24f, -2.19f, 2.92f, -2.43f, 4.8f)
                horizontalLineTo(13.0f)
                verticalLineTo(4.07f)
                close()
                moveTo(13.0f, 19.93f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(2.07f)
                curveToRelative(0.24f, 1.88f, 1.12f, 3.55f, 2.42f, 4.79f)
                curveTo(16.29f, 18.93f, 14.73f, 19.71f, 13.0f, 19.93f)
                close()
                moveTo(18.77f, 16.25f)
                curveToRelative(-0.87f, -0.86f, -1.46f, -1.99f, -1.68f, -3.25f)
                horizontalLineToRelative(2.84f)
                curveTo(19.78f, 14.18f, 19.37f, 15.28f, 18.77f, 16.25f)
                close()
            }
        }
        return _sportsBasketball!!
    }

private var _sportsBasketball: ImageVector? = null
