/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.VerticalSplit: ImageVector
    get() {
        if (_verticalSplit != null) {
            return _verticalSplit!!
        }
        _verticalSplit = materialIcon(name = "TwoTone.VerticalSplit") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.0f, 7.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(10.0f)
                horizontalLineToRelative(-4.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 13.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                lineTo(3.0f, 15.0f)
                close()
                moveTo(3.0f, 17.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                lineTo(3.0f, 19.0f)
                close()
                moveTo(3.0f, 9.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                lineTo(3.0f, 11.0f)
                close()
                moveTo(3.0f, 5.0f)
                horizontalLineToRelative(8.0f)
                verticalLineToRelative(2.0f)
                lineTo(3.0f, 7.0f)
                close()
                moveTo(13.0f, 5.0f)
                verticalLineToRelative(14.0f)
                horizontalLineToRelative(8.0f)
                lineTo(21.0f, 5.0f)
                horizontalLineToRelative(-8.0f)
                close()
                moveTo(19.0f, 17.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(15.0f, 7.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(10.0f)
                close()
            }
        }
        return _verticalSplit!!
    }

private var _verticalSplit: ImageVector? = null
