/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.VolunteerActivism: ImageVector
    get() {
        if (_volunteerActivism != null) {
            return _volunteerActivism!!
        }
        _volunteerActivism = materialIcon(name = "TwoTone.VolunteerActivism") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(3.0f, 13.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(-2.0f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(16.0f, 10.29f)
                curveToRelative(1.96f, -1.82f, 4.0f, -3.88f, 4.0f, -4.99f)
                curveTo(20.0f, 4.56f, 19.44f, 4.0f, 18.7f, 4.0f)
                curveToRelative(-0.44f, 0.0f, -0.89f, 0.21f, -1.18f, 0.55f)
                lineTo(16.0f, 6.34f)
                lineToRelative(-1.52f, -1.79f)
                curveTo(14.19f, 4.21f, 13.74f, 4.0f, 13.3f, 4.0f)
                curveTo(12.56f, 4.0f, 12.0f, 4.56f, 12.0f, 5.3f)
                curveTo(12.0f, 6.41f, 14.04f, 8.47f, 16.0f, 10.29f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(19.0f, 18.0f)
                horizontalLineToRelative(-5.35f)
                curveToRelative(-0.54f, 0.0f, -1.07f, -0.09f, -1.58f, -0.26f)
                lineToRelative(-2.38f, -0.79f)
                lineToRelative(0.63f, -1.9f)
                lineToRelative(2.38f, 0.79f)
                curveToRelative(0.31f, 0.1f, 0.63f, 0.15f, 0.95f, 0.15f)
                horizontalLineTo(15.0f)
                curveToRelative(0.0f, -0.37f, -0.23f, -0.7f, -0.57f, -0.83f)
                lineTo(8.61f, 13.0f)
                horizontalLineTo(7.0f)
                verticalLineToRelative(5.48f)
                lineToRelative(6.97f, 1.94f)
                lineToRelative(5.93f, -1.85f)
                curveTo(19.74f, 18.23f, 19.39f, 18.0f, 19.0f, 18.0f)
                close()
            }
            materialPath {
                moveTo(16.0f, 13.0f)
                curveToRelative(3.09f, -2.81f, 6.0f, -5.44f, 6.0f, -7.7f)
                curveTo(22.0f, 3.45f, 20.55f, 2.0f, 18.7f, 2.0f)
                curveToRelative(-1.04f, 0.0f, -2.05f, 0.49f, -2.7f, 1.25f)
                curveTo(15.35f, 2.49f, 14.34f, 2.0f, 13.3f, 2.0f)
                curveTo(11.45f, 2.0f, 10.0f, 3.45f, 10.0f, 5.3f)
                curveTo(10.0f, 7.56f, 12.91f, 10.19f, 16.0f, 13.0f)
                close()
                moveTo(13.3f, 4.0f)
                curveToRelative(0.44f, 0.0f, 0.89f, 0.21f, 1.18f, 0.55f)
                lineTo(16.0f, 6.34f)
                lineToRelative(1.52f, -1.79f)
                curveTo(17.81f, 4.21f, 18.26f, 4.0f, 18.7f, 4.0f)
                curveTo(19.44f, 4.0f, 20.0f, 4.56f, 20.0f, 5.3f)
                curveToRelative(0.0f, 1.12f, -2.04f, 3.17f, -4.0f, 4.99f)
                curveToRelative(-1.96f, -1.82f, -4.0f, -3.88f, -4.0f, -4.99f)
                curveTo(12.0f, 4.56f, 12.56f, 4.0f, 13.3f, 4.0f)
                close()
            }
            materialPath {
                moveTo(19.0f, 16.0f)
                horizontalLineToRelative(-2.0f)
                curveToRelative(0.0f, -1.2f, -0.75f, -2.28f, -1.87f, -2.7f)
                lineTo(8.97f, 11.0f)
                horizontalLineTo(1.0f)
                verticalLineToRelative(11.0f)
                horizontalLineToRelative(6.0f)
                verticalLineToRelative(-1.44f)
                lineToRelative(7.0f, 1.94f)
                lineToRelative(8.0f, -2.5f)
                verticalLineToRelative(-1.0f)
                curveTo(22.0f, 17.34f, 20.66f, 16.0f, 19.0f, 16.0f)
                close()
                moveTo(5.0f, 20.0f)
                horizontalLineTo(3.0f)
                verticalLineToRelative(-7.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(20.0f)
                close()
                moveTo(13.97f, 20.41f)
                lineTo(7.0f, 18.48f)
                verticalLineTo(13.0f)
                horizontalLineToRelative(1.61f)
                lineToRelative(5.82f, 2.17f)
                curveTo(14.77f, 15.3f, 15.0f, 15.63f, 15.0f, 16.0f)
                horizontalLineToRelative(-1.35f)
                curveToRelative(-0.32f, 0.0f, -0.64f, -0.05f, -0.95f, -0.15f)
                lineToRelative(-2.38f, -0.79f)
                lineToRelative(-0.63f, 1.9f)
                lineToRelative(2.38f, 0.79f)
                curveToRelative(0.51f, 0.17f, 1.04f, 0.26f, 1.58f, 0.26f)
                horizontalLineTo(19.0f)
                curveToRelative(0.39f, 0.0f, 0.74f, 0.23f, 0.9f, 0.56f)
                lineTo(13.97f, 20.41f)
                close()
            }
        }
        return _volunteerActivism!!
    }

private var _volunteerActivism: ImageVector? = null
