/*
 * Copyright 2022 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.WifiCalling: ImageVector
    get() {
        if (_wifiCalling != null) {
            return _wifiCalling!!
        }
        _wifiCalling = materialIcon(name = "TwoTone.WifiCalling") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.2f, 18.21f)
                curveToRelative(1.2f, 0.41f, 2.48f, 0.67f, 3.8f, 0.75f)
                verticalLineToRelative(-1.49f)
                curveToRelative(-0.88f, -0.07f, -1.75f, -0.22f, -2.6f, -0.45f)
                lineTo(15.2f, 18.21f)
                close()
            }
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(6.54f, 5.0f)
                horizontalLineToRelative(-1.5f)
                curveToRelative(0.09f, 1.32f, 0.35f, 2.59f, 0.75f, 3.8f)
                lineToRelative(1.2f, -1.2f)
                curveTo(6.75f, 6.76f, 6.6f, 5.89f, 6.54f, 5.0f)
                close()
            }
            materialPath {
                moveTo(20.0f, 15.51f)
                curveToRelative(-1.24f, 0.0f, -2.45f, -0.2f, -3.57f, -0.57f)
                curveToRelative(-0.1f, -0.04f, -0.21f, -0.05f, -0.31f, -0.05f)
                curveToRelative(-0.26f, 0.0f, -0.51f, 0.1f, -0.71f, 0.29f)
                lineToRelative(-2.2f, 2.2f)
                curveToRelative(-2.83f, -1.45f, -5.15f, -3.76f, -6.59f, -6.59f)
                lineToRelative(2.2f, -2.2f)
                curveTo(9.1f, 8.31f, 9.18f, 7.92f, 9.07f, 7.57f)
                curveTo(8.7f, 6.45f, 8.5f, 5.25f, 8.5f, 4.0f)
                curveToRelative(0.0f, -0.55f, -0.45f, -1.0f, -1.0f, -1.0f)
                horizontalLineTo(4.0f)
                curveTo(3.45f, 3.0f, 3.0f, 3.45f, 3.0f, 4.0f)
                curveToRelative(0.0f, 9.39f, 7.61f, 17.0f, 17.0f, 17.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-3.49f)
                curveTo(21.0f, 15.96f, 20.55f, 15.51f, 20.0f, 15.51f)
                close()
                moveTo(5.03f, 5.0f)
                horizontalLineToRelative(1.5f)
                curveTo(6.6f, 5.89f, 6.75f, 6.76f, 6.99f, 7.59f)
                lineToRelative(-1.2f, 1.2f)
                curveTo(5.38f, 7.59f, 5.12f, 6.32f, 5.03f, 5.0f)
                close()
                moveTo(19.0f, 18.97f)
                curveToRelative(-1.32f, -0.09f, -2.59f, -0.35f, -3.8f, -0.75f)
                lineToRelative(1.19f, -1.19f)
                curveToRelative(0.85f, 0.24f, 1.72f, 0.39f, 2.6f, 0.45f)
                verticalLineTo(18.97f)
                close()
            }
            materialPath {
                moveTo(22.0f, 4.95f)
                curveTo(21.79f, 4.78f, 19.67f, 3.0f, 16.5f, 3.0f)
                curveToRelative(-3.18f, 0.0f, -5.29f, 1.78f, -5.5f, 1.95f)
                lineTo(16.5f, 12.0f)
                lineTo(22.0f, 4.95f)
                close()
            }
        }
        return _wifiCalling!!
    }

private var _wifiCalling: ImageVector? = null
