/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.DirectionsCarFilled: ImageVector
    get() {
        if (_directionsCarFilled != null) {
            return _directionsCarFilled!!
        }
        _directionsCarFilled = materialIcon(name = "Filled.DirectionsCarFilled") {
            materialPath {
                moveTo(18.92f, 6.01f)
                curveTo(18.72f, 5.42f, 18.16f, 5.0f, 17.5f, 5.0f)
                horizontalLineToRelative(-11.0f)
                curveTo(5.84f, 5.0f, 5.29f, 5.42f, 5.08f, 6.01f)
                lineTo(3.0f, 12.0f)
                verticalLineToRelative(8.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(1.0f)
                curveToRelative(0.0f, 0.55f, 0.45f, 1.0f, 1.0f, 1.0f)
                horizontalLineToRelative(1.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, -0.45f, 1.0f, -1.0f)
                verticalLineToRelative(-8.0f)
                lineTo(18.92f, 6.01f)
                close()
                moveTo(7.5f, 16.0f)
                curveTo(6.67f, 16.0f, 6.0f, 15.33f, 6.0f, 14.5f)
                reflectiveCurveTo(6.67f, 13.0f, 7.5f, 13.0f)
                reflectiveCurveTo(9.0f, 13.67f, 9.0f, 14.5f)
                reflectiveCurveTo(8.33f, 16.0f, 7.5f, 16.0f)
                close()
                moveTo(16.5f, 16.0f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(17.33f, 16.0f, 16.5f, 16.0f)
                close()
                moveTo(5.81f, 10.0f)
                lineToRelative(1.04f, -3.0f)
                horizontalLineToRelative(10.29f)
                lineToRelative(1.04f, 3.0f)
                horizontalLineTo(5.81f)
                close()
            }
        }
        return _directionsCarFilled!!
    }

private var _directionsCarFilled: ImageVector? = null
