/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled._6FtApart: ImageVector
    get() {
        if (__6FtApart != null) {
            return __6FtApart!!
        }
        __6FtApart = materialIcon(name = "Filled._6FtApart") {
            materialPath {
                moveTo(6.0f, 6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveTo(7.1f, 2.0f, 6.0f, 2.0f)
                reflectiveCurveTo(4.0f, 2.9f, 4.0f, 4.0f)
                reflectiveCurveTo(4.9f, 6.0f, 6.0f, 6.0f)
                close()
                moveTo(10.0f, 9.43f)
                curveToRelative(0.0f, -0.81f, -0.48f, -1.53f, -1.22f, -1.85f)
                curveTo(7.93f, 7.21f, 6.99f, 7.0f, 6.0f, 7.0f)
                curveTo(5.01f, 7.0f, 4.07f, 7.21f, 3.22f, 7.58f)
                curveTo(2.48f, 7.9f, 2.0f, 8.62f, 2.0f, 9.43f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(9.43f)
                close()
                moveTo(18.0f, 6.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                reflectiveCurveToRelative(-0.9f, -2.0f, -2.0f, -2.0f)
                reflectiveCurveToRelative(-2.0f, 0.9f, -2.0f, 2.0f)
                reflectiveCurveTo(16.9f, 6.0f, 18.0f, 6.0f)
                close()
                moveTo(22.0f, 9.43f)
                curveToRelative(0.0f, -0.81f, -0.48f, -1.53f, -1.22f, -1.85f)
                curveTo(19.93f, 7.21f, 18.99f, 7.0f, 18.0f, 7.0f)
                curveToRelative(-0.99f, 0.0f, -1.93f, 0.21f, -2.78f, 0.58f)
                curveTo(14.48f, 7.9f, 14.0f, 8.62f, 14.0f, 9.43f)
                verticalLineTo(10.0f)
                horizontalLineToRelative(8.0f)
                verticalLineTo(9.43f)
                close()
                moveTo(19.0f, 17.0f)
                verticalLineToRelative(-2.01f)
                lineTo(5.0f, 15.0f)
                verticalLineToRelative(2.0f)
                lineToRelative(-3.0f, -3.0f)
                lineToRelative(3.0f, -3.0f)
                verticalLineToRelative(2.01f)
                lineTo(19.0f, 13.0f)
                verticalLineToRelative(-2.0f)
                lineToRelative(3.0f, 3.0f)
                lineTo(19.0f, 17.0f)
                close()
                moveTo(10.0f, 19.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineTo(7.5f)
                curveTo(7.22f, 18.0f, 7.0f, 18.22f, 7.0f, 18.5f)
                verticalLineToRelative(3.0f)
                curveTo(7.0f, 21.78f, 7.22f, 22.0f, 7.5f, 22.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, -0.22f, 0.5f, -0.5f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, -0.28f, -0.22f, -0.5f, -0.5f, -0.5f)
                horizontalLineTo(8.0f)
                verticalLineTo(19.0f)
                horizontalLineTo(10.0f)
                close()
                moveTo(9.0f, 20.5f)
                verticalLineTo(21.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-0.5f)
                horizontalLineTo(9.0f)
                close()
                moveTo(17.5f, 19.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-1.0f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(19.0f)
                close()
                moveTo(12.5f, 19.0f)
                verticalLineToRelative(0.5f)
                horizontalLineToRelative(1.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(-1.0f)
                verticalLineToRelative(-4.0f)
                horizontalLineTo(14.0f)
                verticalLineToRelative(1.0f)
                horizontalLineTo(12.5f)
                close()
            }
        }
        return __6FtApart!!
    }

private var __6FtApart: ImageVector? = null
