/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Cabin: ImageVector
    get() {
        if (_cabin != null) {
            return _cabin!!
        }
        _cabin = materialIcon(name = "Rounded.Cabin") {
            materialPath {
                moveTo(4.37f, 3.55f)
                curveTo(4.89f, 2.62f, 5.87f, 2.0f, 7.0f, 2.0f)
                curveToRelative(0.38f, 0.0f, 0.72f, -0.22f, 0.89f, -0.53f)
                curveTo(8.04f, 1.16f, 8.39f, 1.0f, 8.73f, 1.0f)
                curveToRelative(0.74f, 0.0f, 1.26f, 0.8f, 0.9f, 1.45f)
                curveTo(9.11f, 3.38f, 8.13f, 4.0f, 7.0f, 4.0f)
                curveTo(6.62f, 4.0f, 6.28f, 4.22f, 6.11f, 4.53f)
                curveTo(5.96f, 4.84f, 5.61f, 5.0f, 5.27f, 5.0f)
                curveTo(4.53f, 5.0f, 4.01f, 4.2f, 4.37f, 3.55f)
                close()
                moveTo(22.39f, 12.19f)
                curveToRelative(-0.34f, 0.44f, -0.96f, 0.52f, -1.4f, 0.19f)
                lineTo(20.0f, 11.62f)
                verticalLineTo(20.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                horizontalLineTo(5.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                verticalLineToRelative(-8.38f)
                lineToRelative(-0.99f, 0.76f)
                curveToRelative(-0.44f, 0.34f, -1.07f, 0.25f, -1.4f, -0.19f)
                curveToRelative(-0.33f, -0.44f, -0.25f, -1.07f, 0.19f, -1.4f)
                lineTo(4.0f, 9.11f)
                verticalLineTo(7.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(0.58f)
                lineToRelative(5.39f, -4.12f)
                curveToRelative(0.36f, -0.27f, 0.86f, -0.27f, 1.21f, 0.0f)
                lineToRelative(9.6f, 7.33f)
                curveTo(22.64f, 11.13f, 22.73f, 11.76f, 22.39f, 12.19f)
                close()
                moveTo(10.06f, 7.0f)
                horizontalLineToRelative(3.89f)
                lineTo(12.0f, 5.52f)
                lineTo(10.06f, 7.0f)
                close()
                moveTo(6.0f, 10.1f)
                verticalLineTo(11.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-0.9f)
                lineTo(16.56f, 9.0f)
                horizontalLineTo(7.44f)
                lineTo(6.0f, 10.1f)
                close()
                moveTo(6.0f, 13.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(12.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(6.0f)
                close()
                moveTo(18.0f, 19.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineTo(6.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(18.0f)
                close()
            }
        }
        return _cabin!!
    }

private var _cabin: ImageVector? = null
