/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.RollerSkating: ImageVector
    get() {
        if (_rollerSkating != null) {
            return _rollerSkating!!
        }
        _rollerSkating = materialIcon(name = "Rounded.RollerSkating") {
            materialPath {
                moveTo(18.0f, 16.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineToRelative(0.0f, -0.88f)
                curveToRelative(0.0f, -2.1f, -1.55f, -3.53f, -3.03f, -3.88f)
                lineToRelative(-2.7f, -0.67f)
                curveTo(13.4f, 8.35f, 12.7f, 7.76f, 12.32f, 7.0f)
                horizontalLineTo(9.5f)
                curveTo(9.22f, 7.0f, 9.0f, 6.78f, 9.0f, 6.5f)
                reflectiveCurveTo(9.22f, 6.0f, 9.5f, 6.0f)
                horizontalLineToRelative(2.52f)
                lineTo(12.0f, 5.0f)
                horizontalLineTo(9.5f)
                curveTo(9.22f, 5.0f, 9.0f, 4.78f, 9.0f, 4.5f)
                curveTo(9.0f, 4.22f, 9.22f, 4.0f, 9.5f, 4.0f)
                horizontalLineTo(12.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                horizontalLineTo(6.0f)
                curveTo(4.9f, 1.0f, 4.0f, 1.9f, 4.0f, 3.0f)
                verticalLineToRelative(11.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineTo(18.0f)
                close()
                moveTo(5.0f, 23.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(6.66f, 23.0f, 5.0f, 23.0f)
                close()
                moveTo(19.0f, 23.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(20.66f, 23.0f, 19.0f, 23.0f)
                close()
                moveTo(12.0f, 23.0f)
                curveToRelative(-1.66f, 0.0f, -3.0f, -1.34f, -3.0f, -3.0f)
                reflectiveCurveToRelative(1.34f, -3.0f, 3.0f, -3.0f)
                reflectiveCurveToRelative(3.0f, 1.34f, 3.0f, 3.0f)
                reflectiveCurveTo(13.66f, 23.0f, 12.0f, 23.0f)
                close()
            }
        }
        return _rollerSkating!!
    }

private var _rollerSkating: ImageVector? = null
