/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SignalWifiOff: ImageVector
    get() {
        if (_signalWifiOff != null) {
            return _signalWifiOff!!
        }
        _signalWifiOff = materialIcon(name = "Rounded.SignalWifiOff") {
            materialPath {
                moveTo(23.64f, 7.0f)
                curveToRelative(-0.45f, -0.34f, -4.93f, -4.0f, -11.64f, -4.0f)
                curveToRelative(-1.32f, 0.0f, -2.55f, 0.14f, -3.69f, 0.38f)
                lineTo(18.43f, 13.5f)
                lineTo(23.64f, 7.0f)
                close()
                moveTo(4.12f, 2.01f)
                curveToRelative(-0.39f, -0.39f, -1.02f, -0.39f, -1.41f, 0.0f)
                curveToRelative(-0.39f, 0.39f, -0.39f, 1.02f, 0.0f, 1.41f)
                lineToRelative(1.35f, 1.35f)
                curveTo(1.91f, 5.76f, 0.59f, 6.82f, 0.36f, 7.0f)
                lineToRelative(10.08f, 12.56f)
                curveToRelative(0.8f, 1.0f, 2.32f, 1.0f, 3.12f, 0.0f)
                lineToRelative(2.35f, -2.93f)
                lineToRelative(2.61f, 2.61f)
                curveToRelative(0.39f, 0.39f, 1.02f, 0.39f, 1.41f, 0.0f)
                curveToRelative(0.39f, -0.39f, 0.39f, -1.02f, 0.0f, -1.41f)
                lineTo(4.12f, 2.01f)
                close()
            }
        }
        return _signalWifiOff!!
    }

private var _signalWifiOff: ImageVector? = null
