/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.CarRental: ImageVector
    get() {
        if (_carRental != null) {
            return _carRental!!
        }
        _carRental = materialIcon(name = "Sharp.CarRental") {
            materialPath {
                moveTo(10.83f, 3.0f)
                curveTo(10.41f, 1.83f, 9.3f, 1.0f, 8.0f, 1.0f)
                curveTo(6.34f, 1.0f, 5.0f, 2.34f, 5.0f, 4.0f)
                curveToRelative(0.0f, 1.65f, 1.34f, 3.0f, 3.0f, 3.0f)
                curveToRelative(1.3f, 0.0f, 2.41f, -0.84f, 2.83f, -2.0f)
                horizontalLineTo(16.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineTo(5.0f)
                horizontalLineToRelative(1.0f)
                verticalLineTo(3.0f)
                horizontalLineTo(10.83f)
                close()
                moveTo(8.0f, 5.0f)
                curveTo(7.45f, 5.0f, 7.0f, 4.55f, 7.0f, 4.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(8.55f, 5.0f, 8.0f, 5.0f)
                close()
                moveTo(17.11f, 9.0f)
                horizontalLineTo(6.89f)
                lineTo(5.0f, 14.69f)
                verticalLineTo(22.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(-7.31f)
                lineTo(17.11f, 9.0f)
                close()
                moveTo(9.0f, 17.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(9.55f, 17.5f, 9.0f, 17.5f)
                close()
                moveTo(15.0f, 17.5f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                reflectiveCurveToRelative(1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveTo(15.55f, 17.5f, 15.0f, 17.5f)
                close()
                moveTo(7.67f, 13.0f)
                lineToRelative(0.66f, -2.0f)
                horizontalLineToRelative(7.34f)
                lineToRelative(0.66f, 2.0f)
                horizontalLineTo(7.67f)
                close()
            }
        }
        return _carRental!!
    }

private var _carRental: ImageVector? = null
