/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.MobileScreenShare: ImageVector
    get() {
        if (_mobileScreenShare != null) {
            return _mobileScreenShare!!
        }
        _mobileScreenShare = materialIcon(name = "Sharp.MobileScreenShare") {
            materialPath {
                moveTo(5.01f, 1.0f)
                verticalLineToRelative(22.0f)
                lineTo(19.0f, 23.0f)
                lineTo(19.0f, 1.0f)
                lineTo(5.01f, 1.0f)
                close()
                moveTo(17.0f, 19.0f)
                lineTo(7.0f, 19.0f)
                lineTo(7.0f, 5.0f)
                horizontalLineToRelative(10.0f)
                verticalLineToRelative(14.0f)
                close()
                moveTo(12.8f, 13.24f)
                verticalLineToRelative(1.75f)
                lineTo(16.0f, 12.0f)
                lineToRelative(-3.2f, -2.98f)
                verticalLineToRelative(1.7f)
                curveToRelative(-3.11f, 0.43f, -4.35f, 2.56f, -4.8f, 4.7f)
                curveToRelative(1.11f, -1.5f, 2.58f, -2.18f, 4.8f, -2.18f)
                close()
            }
        }
        return _mobileScreenShare!!
    }

private var _mobileScreenShare: ImageVector? = null
