/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.SubtitlesOff: ImageVector
    get() {
        if (_subtitlesOff != null) {
            return _subtitlesOff!!
        }
        _subtitlesOff = materialIcon(name = "Sharp.SubtitlesOff") {
            materialPath {
                moveTo(6.83f, 4.0f)
                lineToRelative(8.0f, 8.0f)
                lineToRelative(5.17f, 0.0f)
                lineToRelative(0.0f, 2.0f)
                lineToRelative(-3.17f, 0.0f)
                lineToRelative(5.17f, 5.17f)
                lineToRelative(0.0f, -15.17f)
                close()
            }
            materialPath {
                moveTo(1.04f, 3.87f)
                lineTo(2.0f, 4.83f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(15.17f)
                lineToRelative(2.96f, 2.96f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.45f, 2.45f)
                lineTo(1.04f, 3.87f)
                close()
                moveTo(4.0f, 12.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(12.0f)
                close()
                moveTo(4.0f, 16.0f)
                horizontalLineToRelative(9.17f)
                lineTo(14.0f, 16.83f)
                verticalLineTo(18.0f)
                horizontalLineTo(4.0f)
                verticalLineTo(16.0f)
                close()
            }
        }
        return _subtitlesOff!!
    }

private var _subtitlesOff: ImageVector? = null
