/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.VideoSettings: ImageVector
    get() {
        if (_videoSettings != null) {
            return _videoSettings!!
        }
        _videoSettings = materialIcon(name = "Sharp.VideoSettings") {
            materialPath {
                moveTo(3.0f, 6.0f)
                lineToRelative(18.0f, 0.0f)
                lineToRelative(0.0f, 5.0f)
                lineToRelative(2.0f, 0.0f)
                lineToRelative(0.0f, -7.0f)
                lineToRelative(-22.0f, 0.0f)
                lineToRelative(0.0f, 16.0f)
                lineToRelative(11.0f, 0.0f)
                lineToRelative(0.0f, -2.0f)
                lineToRelative(-9.0f, 0.0f)
                close()
            }
            materialPath {
                moveTo(15.0f, 12.0f)
                lineToRelative(-6.0f, -4.0f)
                lineToRelative(0.0f, 8.0f)
                close()
            }
            materialPath {
                moveTo(22.72f, 17.57f)
                lineToRelative(1.23f, -0.98f)
                lineToRelative(-1.25f, -2.17f)
                lineTo(21.23f, 15.0f)
                curveToRelative(-0.23f, -0.17f, -0.48f, -0.31f, -0.75f, -0.42f)
                lineTo(20.25f, 13.0f)
                horizontalLineToRelative(-2.5f)
                lineToRelative(-0.24f, 1.58f)
                curveToRelative(-0.26f, 0.11f, -0.51f, 0.26f, -0.74f, 0.42f)
                lineToRelative(-1.48f, -0.58f)
                lineToRelative(-1.25f, 2.17f)
                lineToRelative(1.24f, 0.99f)
                curveToRelative(-0.03f, 0.29f, -0.04f, 0.58f, -0.01f, 0.86f)
                lineToRelative(-1.23f, 0.98f)
                lineToRelative(1.25f, 2.17f)
                lineTo(16.77f, 21.0f)
                curveToRelative(0.23f, 0.17f, 0.48f, 0.31f, 0.75f, 0.42f)
                lineTo(17.75f, 23.0f)
                horizontalLineToRelative(2.5f)
                lineToRelative(0.24f, -1.58f)
                curveToRelative(0.26f, -0.11f, 0.51f, -0.26f, 0.74f, -0.42f)
                lineToRelative(1.48f, 0.58f)
                lineToRelative(1.25f, -2.17f)
                lineToRelative(-1.24f, -0.99f)
                curveTo(22.75f, 18.14f, 22.75f, 17.85f, 22.72f, 17.57f)
                close()
                moveTo(19.0f, 19.5f)
                curveToRelative(-0.83f, 0.0f, -1.5f, -0.67f, -1.5f, -1.5f)
                reflectiveCurveToRelative(0.67f, -1.5f, 1.5f, -1.5f)
                reflectiveCurveToRelative(1.5f, 0.67f, 1.5f, 1.5f)
                reflectiveCurveTo(19.83f, 19.5f, 19.0f, 19.5f)
                close()
            }
        }
        return _videoSettings!!
    }

private var _videoSettings: ImageVector? = null
