/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.Water: ImageVector
    get() {
        if (_water != null) {
            return _water!!
        }
        _water = materialIcon(name = "Sharp.Water") {
            materialPath {
                moveTo(21.98f, 14.0f)
                horizontalLineTo(22.0f)
                horizontalLineTo(21.98f)
                close()
                moveTo(5.35f, 13.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.4f, 0.98f, 3.31f, 1.0f)
                verticalLineToRelative(-2.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveTo(3.38f, 11.0f, 3.24f, 12.0f, 2.0f, 12.0f)
                verticalLineToRelative(2.0f)
                curveTo(3.9f, 14.0f, 4.17f, 13.0f, 5.35f, 13.0f)
                close()
                moveTo(18.67f, 15.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.1f, 1.0f, -3.34f, 1.0f)
                curveToRelative(-1.24f, 0.0f, -1.38f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.1f, 1.0f, -3.34f, 1.0f)
                verticalLineToRelative(2.0f)
                curveToRelative(1.95f, 0.0f, 2.11f, -1.0f, 3.34f, -1.0f)
                curveToRelative(1.24f, 0.0f, 1.38f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.1f, -1.0f, 3.34f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.94f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                verticalLineToRelative(-2.0f)
                curveTo(20.76f, 16.0f, 20.62f, 15.0f, 18.67f, 15.0f)
                close()
                moveTo(5.35f, 9.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.42f, 1.0f, 3.33f, 1.0f)
                curveToRelative(1.95f, 0.0f, 2.09f, -1.0f, 3.33f, -1.0f)
                curveToRelative(1.19f, 0.0f, 1.4f, 0.98f, 3.31f, 1.0f)
                verticalLineTo(8.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveToRelative(-1.95f, 0.0f, -2.09f, 1.0f, -3.33f, 1.0f)
                curveToRelative(-1.19f, 0.0f, -1.42f, -1.0f, -3.33f, -1.0f)
                curveTo(10.04f, 7.0f, 9.9f, 8.0f, 8.66f, 8.0f)
                curveTo(7.47f, 8.0f, 7.24f, 7.0f, 5.33f, 7.0f)
                curveTo(3.38f, 7.0f, 3.24f, 8.0f, 2.0f, 8.0f)
                verticalLineToRelative(2.0f)
                curveTo(3.9f, 10.0f, 4.17f, 9.0f, 5.35f, 9.0f)
                close()
            }
        }
        return _water!!
    }

private var _water: ImageVector? = null
