/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.MoveDown: ImageVector
    get() {
        if (_moveDown != null) {
            return _moveDown!!
        }
        _moveDown = materialIcon(name = "TwoTone.MoveDown") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(15.0f, 6.0f)
                horizontalLineToRelative(5.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(-5.0f)
                close()
            }
            materialPath {
                moveTo(3.0f, 11.0f)
                curveToRelative(0.0f, 2.45f, 1.76f, 4.47f, 4.08f, 4.91f)
                lineToRelative(-1.49f, -1.49f)
                lineTo(7.0f, 13.0f)
                lineToRelative(4.0f, 4.01f)
                lineTo(7.0f, 21.0f)
                lineToRelative(-1.41f, -1.41f)
                lineToRelative(1.58f, -1.58f)
                lineToRelative(0.0f, -0.06f)
                curveTo(3.7f, 17.54f, 1.0f, 14.58f, 1.0f, 11.0f)
                curveToRelative(0.0f, -3.87f, 3.13f, -7.0f, 7.0f, -7.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineTo(8.0f)
                curveTo(5.24f, 6.0f, 3.0f, 8.24f, 3.0f, 11.0f)
                close()
            }
            materialPath {
                moveTo(22.0f, 11.0f)
                verticalLineTo(4.0f)
                horizontalLineToRelative(-9.0f)
                verticalLineToRelative(7.0f)
                horizontalLineTo(22.0f)
                close()
                moveTo(20.0f, 9.0f)
                horizontalLineToRelative(-5.0f)
                verticalLineTo(6.0f)
                horizontalLineToRelative(5.0f)
                verticalLineTo(9.0f)
                close()
            }
            materialPath {
                moveTo(13.0f, 13.0f)
                horizontalLineToRelative(9.0f)
                verticalLineToRelative(7.0f)
                horizontalLineToRelative(-9.0f)
                close()
            }
        }
        return _moveDown!!
    }

private var _moveDown: ImageVector? = null
