/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.HdrOff: ImageVector
    get() {
        if (_hdrOff != null) {
            return _hdrOff!!
        }
        _hdrOff = materialIcon(name = "Filled.HdrOff") {
            materialPath {
                moveTo(17.5f, 15.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(1.1f)
                lineToRelative(0.9f, 2.0f)
                lineTo(21.0f, 15.0f)
                lineToRelative(-0.9f, -2.1f)
                curveToRelative(0.5f, -0.2f, 0.9f, -0.8f, 0.9f, -1.4f)
                verticalLineToRelative(-1.0f)
                curveToRelative(0.0f, -0.8f, -0.7f, -1.5f, -1.5f, -1.5f)
                lineTo(16.0f, 9.0f)
                verticalLineToRelative(4.9f)
                lineToRelative(1.1f, 1.1f)
                horizontalLineToRelative(0.4f)
                close()
                moveTo(17.5f, 10.5f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(1.0f)
                horizontalLineToRelative(-2.0f)
                verticalLineToRelative(-1.0f)
                close()
                moveTo(13.0f, 10.5f)
                verticalLineToRelative(0.4f)
                lineToRelative(1.5f, 1.5f)
                verticalLineToRelative(-1.9f)
                curveToRelative(0.0f, -0.8f, -0.7f, -1.5f, -1.5f, -1.5f)
                horizontalLineToRelative(-1.9f)
                lineToRelative(1.5f, 1.5f)
                horizontalLineToRelative(0.4f)
                close()
                moveTo(9.5f, 9.5f)
                lineToRelative(-7.0f, -7.0f)
                lineToRelative(-1.1f, 1.0f)
                lineTo(6.9f, 9.0f)
                horizontalLineToRelative(-0.4f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-2.0f)
                lineTo(4.5f, 9.0f)
                lineTo(3.0f, 9.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(1.5f)
                verticalLineToRelative(-2.5f)
                horizontalLineToRelative(2.0f)
                lineTo(6.5f, 15.0f)
                lineTo(8.0f, 15.0f)
                verticalLineToRelative(-4.9f)
                lineToRelative(1.5f, 1.5f)
                lineTo(9.5f, 15.0f)
                horizontalLineToRelative(3.4f)
                lineToRelative(7.6f, 7.6f)
                lineToRelative(1.1f, -1.1f)
                lineToRelative(-12.1f, -12.0f)
                close()
            }
        }
        return _hdrOff!!
    }

private var _hdrOff: ImageVector? = null
