/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.Replay30: ImageVector
    get() {
        if (_replay30 != null) {
            return _replay30!!
        }
        _replay30 = materialIcon(name = "Filled.Replay30") {
            materialPath {
                moveTo(12.0f, 5.0f)
                verticalLineTo(1.0f)
                lineTo(7.0f, 6.0f)
                lineToRelative(5.0f, 5.0f)
                verticalLineTo(7.0f)
                curveToRelative(3.31f, 0.0f, 6.0f, 2.69f, 6.0f, 6.0f)
                reflectiveCurveToRelative(-2.69f, 6.0f, -6.0f, 6.0f)
                reflectiveCurveToRelative(-6.0f, -2.69f, -6.0f, -6.0f)
                horizontalLineTo(4.0f)
                curveToRelative(0.0f, 4.42f, 3.58f, 8.0f, 8.0f, 8.0f)
                reflectiveCurveToRelative(8.0f, -3.58f, 8.0f, -8.0f)
                reflectiveCurveTo(16.42f, 5.0f, 12.0f, 5.0f)
                close()
            }
            materialPath {
                moveTo(9.56f, 13.49f)
                horizontalLineToRelative(0.45f)
                curveToRelative(0.21f, 0.0f, 0.37f, -0.05f, 0.48f, -0.16f)
                reflectiveCurveToRelative(0.16f, -0.25f, 0.16f, -0.43f)
                curveToRelative(0.0f, -0.08f, -0.01f, -0.15f, -0.04f, -0.22f)
                reflectiveCurveToRelative(-0.06f, -0.12f, -0.11f, -0.17f)
                reflectiveCurveToRelative(-0.11f, -0.09f, -0.18f, -0.11f)
                reflectiveCurveToRelative(-0.16f, -0.04f, -0.25f, -0.04f)
                curveToRelative(-0.08f, 0.0f, -0.15f, 0.01f, -0.22f, 0.03f)
                reflectiveCurveToRelative(-0.13f, 0.05f, -0.18f, 0.1f)
                reflectiveCurveToRelative(-0.09f, 0.09f, -0.12f, 0.15f)
                reflectiveCurveToRelative(-0.05f, 0.13f, -0.05f, 0.2f)
                horizontalLineTo(8.65f)
                curveToRelative(0.0f, -0.18f, 0.04f, -0.34f, 0.11f, -0.48f)
                reflectiveCurveToRelative(0.17f, -0.27f, 0.3f, -0.37f)
                reflectiveCurveToRelative(0.27f, -0.18f, 0.44f, -0.23f)
                reflectiveCurveToRelative(0.35f, -0.08f, 0.54f, -0.08f)
                curveToRelative(0.21f, 0.0f, 0.41f, 0.03f, 0.59f, 0.08f)
                reflectiveCurveToRelative(0.33f, 0.13f, 0.46f, 0.23f)
                reflectiveCurveToRelative(0.23f, 0.23f, 0.3f, 0.38f)
                reflectiveCurveToRelative(0.11f, 0.33f, 0.11f, 0.53f)
                curveToRelative(0.0f, 0.09f, -0.01f, 0.18f, -0.04f, 0.27f)
                reflectiveCurveToRelative(-0.07f, 0.17f, -0.13f, 0.25f)
                reflectiveCurveToRelative(-0.12f, 0.15f, -0.2f, 0.22f)
                reflectiveCurveToRelative(-0.17f, 0.12f, -0.28f, 0.17f)
                curveToRelative(0.24f, 0.09f, 0.42f, 0.21f, 0.54f, 0.39f)
                reflectiveCurveToRelative(0.18f, 0.38f, 0.18f, 0.61f)
                curveToRelative(0.0f, 0.2f, -0.04f, 0.38f, -0.12f, 0.53f)
                reflectiveCurveToRelative(-0.18f, 0.29f, -0.32f, 0.39f)
                reflectiveCurveToRelative(-0.29f, 0.19f, -0.48f, 0.24f)
                reflectiveCurveToRelative(-0.38f, 0.08f, -0.6f, 0.08f)
                curveToRelative(-0.18f, 0.0f, -0.36f, -0.02f, -0.53f, -0.07f)
                reflectiveCurveToRelative(-0.33f, -0.12f, -0.46f, -0.23f)
                reflectiveCurveToRelative(-0.25f, -0.23f, -0.33f, -0.38f)
                reflectiveCurveToRelative(-0.12f, -0.34f, -0.12f, -0.55f)
                horizontalLineToRelative(0.85f)
                curveToRelative(0.0f, 0.08f, 0.02f, 0.15f, 0.05f, 0.22f)
                reflectiveCurveToRelative(0.07f, 0.12f, 0.13f, 0.17f)
                reflectiveCurveToRelative(0.12f, 0.09f, 0.2f, 0.11f)
                reflectiveCurveToRelative(0.16f, 0.04f, 0.25f, 0.04f)
                curveToRelative(0.1f, 0.0f, 0.19f, -0.01f, 0.27f, -0.04f)
                reflectiveCurveToRelative(0.15f, -0.07f, 0.2f, -0.12f)
                reflectiveCurveToRelative(0.1f, -0.11f, 0.13f, -0.18f)
                reflectiveCurveToRelative(0.04f, -0.15f, 0.04f, -0.24f)
                curveToRelative(0.0f, -0.11f, -0.02f, -0.21f, -0.05f, -0.29f)
                reflectiveCurveToRelative(-0.08f, -0.15f, -0.14f, -0.2f)
                reflectiveCurveToRelative(-0.13f, -0.09f, -0.22f, -0.11f)
                reflectiveCurveToRelative(-0.18f, -0.04f, -0.29f, -0.04f)
                horizontalLineTo(9.56f)
                verticalLineTo(13.49f)
                close()
            }
            materialPath {
                moveTo(15.3f, 14.24f)
                curveToRelative(0.0f, 0.32f, -0.03f, 0.6f, -0.1f, 0.82f)
                reflectiveCurveToRelative(-0.17f, 0.42f, -0.29f, 0.57f)
                reflectiveCurveToRelative(-0.28f, 0.26f, -0.45f, 0.33f)
                reflectiveCurveToRelative(-0.37f, 0.1f, -0.59f, 0.1f)
                reflectiveCurveToRelative(-0.41f, -0.03f, -0.59f, -0.1f)
                reflectiveCurveToRelative(-0.33f, -0.18f, -0.46f, -0.33f)
                reflectiveCurveToRelative(-0.23f, -0.34f, -0.3f, -0.57f)
                reflectiveCurveToRelative(-0.11f, -0.5f, -0.11f, -0.82f)
                verticalLineTo(13.5f)
                curveToRelative(0.0f, -0.32f, 0.03f, -0.6f, 0.1f, -0.82f)
                reflectiveCurveToRelative(0.17f, -0.42f, 0.29f, -0.57f)
                reflectiveCurveToRelative(0.28f, -0.26f, 0.45f, -0.33f)
                reflectiveCurveToRelative(0.37f, -0.1f, 0.59f, -0.1f)
                reflectiveCurveToRelative(0.41f, 0.03f, 0.59f, 0.1f)
                reflectiveCurveToRelative(0.33f, 0.18f, 0.46f, 0.33f)
                reflectiveCurveToRelative(0.23f, 0.34f, 0.3f, 0.57f)
                reflectiveCurveToRelative(0.11f, 0.5f, 0.11f, 0.82f)
                verticalLineTo(14.24f)
                close()
                moveTo(14.45f, 13.38f)
                curveToRelative(0.0f, -0.19f, -0.01f, -0.35f, -0.04f, -0.48f)
                curveToRelative(-0.03f, -0.13f, -0.07f, -0.23f, -0.12f, -0.31f)
                reflectiveCurveToRelative(-0.11f, -0.14f, -0.19f, -0.17f)
                reflectiveCurveToRelative(-0.16f, -0.05f, -0.25f, -0.05f)
                reflectiveCurveToRelative(-0.18f, 0.02f, -0.25f, 0.05f)
                reflectiveCurveToRelative(-0.14f, 0.09f, -0.19f, 0.17f)
                reflectiveCurveToRelative(-0.09f, 0.18f, -0.12f, 0.31f)
                reflectiveCurveToRelative(-0.04f, 0.29f, -0.04f, 0.48f)
                verticalLineToRelative(0.97f)
                curveToRelative(0.0f, 0.19f, 0.01f, 0.35f, 0.04f, 0.48f)
                reflectiveCurveToRelative(0.07f, 0.24f, 0.12f, 0.32f)
                reflectiveCurveToRelative(0.11f, 0.14f, 0.19f, 0.17f)
                reflectiveCurveToRelative(0.16f, 0.05f, 0.25f, 0.05f)
                reflectiveCurveToRelative(0.18f, -0.02f, 0.25f, -0.05f)
                reflectiveCurveToRelative(0.14f, -0.09f, 0.19f, -0.17f)
                reflectiveCurveToRelative(0.09f, -0.19f, 0.11f, -0.32f)
                curveToRelative(0.03f, -0.13f, 0.04f, -0.29f, 0.04f, -0.48f)
                verticalLineTo(13.38f)
                close()
            }
        }
        return _replay30!!
    }

private var _replay30: ImageVector? = null
