/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.SentimentVeryDissatisfied: ImageVector
    get() {
        if (_sentimentVeryDissatisfied != null) {
            return _sentimentVeryDissatisfied!!
        }
        _sentimentVeryDissatisfied = materialIcon(name = "Outlined.SentimentVeryDissatisfied") {
            materialPath {
                moveTo(12.0f, 13.5f)
                curveToRelative(-2.33f, 0.0f, -4.31f, 1.46f, -5.11f, 3.5f)
                horizontalLineToRelative(10.22f)
                curveToRelative(-0.8f, -2.04f, -2.78f, -3.5f, -5.11f, -3.5f)
                close()
                moveTo(7.82f, 12.0f)
                lineToRelative(1.06f, -1.06f)
                lineTo(9.94f, 12.0f)
                lineTo(11.0f, 10.94f)
                lineTo(9.94f, 9.88f)
                lineTo(11.0f, 8.82f)
                lineTo(9.94f, 7.76f)
                lineTo(8.88f, 8.82f)
                lineTo(7.82f, 7.76f)
                lineTo(6.76f, 8.82f)
                lineToRelative(1.06f, 1.06f)
                lineToRelative(-1.06f, 1.06f)
                close()
                moveTo(11.99f, 2.0f)
                curveTo(6.47f, 2.0f, 2.0f, 6.47f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.47f, 10.0f, 9.99f, 10.0f)
                reflectiveCurveTo(22.0f, 17.53f, 22.0f, 12.0f)
                reflectiveCurveTo(17.52f, 2.0f, 11.99f, 2.0f)
                close()
                moveTo(12.0f, 20.0f)
                curveToRelative(-4.42f, 0.0f, -8.0f, -3.58f, -8.0f, -8.0f)
                reflectiveCurveToRelative(3.58f, -8.0f, 8.0f, -8.0f)
                reflectiveCurveToRelative(8.0f, 3.58f, 8.0f, 8.0f)
                reflectiveCurveToRelative(-3.58f, 8.0f, -8.0f, 8.0f)
                close()
                moveTo(16.18f, 7.76f)
                lineToRelative(-1.06f, 1.06f)
                lineToRelative(-1.06f, -1.06f)
                lineTo(13.0f, 8.82f)
                lineToRelative(1.06f, 1.06f)
                lineTo(13.0f, 10.94f)
                lineTo(14.06f, 12.0f)
                lineToRelative(1.06f, -1.06f)
                lineTo(16.18f, 12.0f)
                lineToRelative(1.06f, -1.06f)
                lineToRelative(-1.06f, -1.06f)
                lineToRelative(1.06f, -1.06f)
                close()
            }
        }
        return _sentimentVeryDissatisfied!!
    }

private var _sentimentVeryDissatisfied: ImageVector? = null
