/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.AllInclusive: ImageVector
    get() {
        if (_allInclusive != null) {
            return _allInclusive!!
        }
        _allInclusive = materialIcon(name = "Rounded.AllInclusive") {
            materialPath {
                moveTo(20.22f, 6.86f)
                curveToRelative(-2.0f, -0.6f, -4.06f, -0.04f, -5.39f, 1.29f)
                lineTo(12.0f, 10.66f)
                lineTo(10.48f, 12.0f)
                horizontalLineToRelative(0.01f)
                lineTo(7.8f, 14.39f)
                curveToRelative(-0.81f, 0.81f, -1.95f, 1.15f, -3.12f, 0.92f)
                curveToRelative(-1.25f, -0.25f, -2.28f, -1.25f, -2.57f, -2.49f)
                curveToRelative(-0.52f, -2.23f, 1.16f, -4.2f, 3.29f, -4.2f)
                curveToRelative(0.91f, 0.0f, 1.76f, 0.35f, 2.44f, 1.03f)
                lineToRelative(0.47f, 0.41f)
                curveToRelative(0.38f, 0.34f, 0.95f, 0.34f, 1.33f, 0.0f)
                curveToRelative(0.45f, -0.4f, 0.45f, -1.1f, 0.0f, -1.5f)
                lineToRelative(-0.42f, -0.36f)
                curveTo(8.2f, 7.18f, 6.84f, 6.62f, 5.4f, 6.62f)
                curveTo(2.42f, 6.62f, 0.0f, 9.04f, 0.0f, 12.0f)
                reflectiveCurveToRelative(2.42f, 5.38f, 5.4f, 5.38f)
                curveToRelative(1.44f, 0.0f, 2.8f, -0.56f, 3.77f, -1.53f)
                lineToRelative(2.83f, -2.5f)
                lineToRelative(0.01f, 0.01f)
                lineTo(13.52f, 12.0f)
                horizontalLineToRelative(-0.01f)
                lineToRelative(2.69f, -2.39f)
                curveToRelative(0.81f, -0.81f, 1.95f, -1.15f, 3.12f, -0.92f)
                curveToRelative(1.25f, 0.25f, 2.28f, 1.25f, 2.57f, 2.49f)
                curveToRelative(0.52f, 2.23f, -1.16f, 4.2f, -3.29f, 4.2f)
                curveToRelative(-0.9f, 0.0f, -1.76f, -0.35f, -2.44f, -1.03f)
                lineToRelative(-0.48f, -0.42f)
                curveToRelative(-0.38f, -0.34f, -0.95f, -0.34f, -1.33f, 0.0f)
                curveToRelative(-0.45f, 0.4f, -0.45f, 1.1f, 0.0f, 1.5f)
                lineToRelative(0.42f, 0.37f)
                curveToRelative(1.02f, 1.01f, 2.37f, 1.57f, 3.82f, 1.57f)
                curveToRelative(3.27f, 0.0f, 5.86f, -2.9f, 5.33f, -6.25f)
                curveToRelative(-0.3f, -1.99f, -1.77f, -3.69f, -3.7f, -4.26f)
                close()
            }
        }
        return _allInclusive!!
    }

private var _allInclusive: ImageVector? = null
