/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.PermCameraMic: ImageVector
    get() {
        if (_permCameraMic != null) {
            return _permCameraMic!!
        }
        _permCameraMic = materialIcon(name = "Rounded.PermCameraMic") {
            materialPath {
                moveTo(20.0f, 5.0f)
                horizontalLineToRelative(-3.17f)
                lineToRelative(-1.24f, -1.35f)
                curveToRelative(-0.37f, -0.41f, -0.91f, -0.65f, -1.47f, -0.65f)
                lineTo(9.88f, 3.0f)
                curveToRelative(-0.56f, 0.0f, -1.1f, 0.24f, -1.48f, 0.65f)
                lineTo(7.17f, 5.0f)
                lineTo(4.0f, 5.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(12.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(7.0f)
                verticalLineToRelative(-2.09f)
                curveToRelative(-2.45f, -0.42f, -4.41f, -2.32f, -4.89f, -4.75f)
                curveToRelative(-0.12f, -0.61f, 0.38f, -1.16f, 0.99f, -1.16f)
                curveToRelative(0.49f, 0.0f, 0.88f, 0.35f, 0.98f, 0.83f)
                curveTo(8.47f, 15.64f, 10.07f, 17.0f, 12.0f, 17.0f)
                reflectiveCurveToRelative(3.53f, -1.36f, 3.91f, -3.17f)
                curveToRelative(0.1f, -0.48f, 0.5f, -0.83f, 0.98f, -0.83f)
                curveToRelative(0.61f, 0.0f, 1.11f, 0.55f, 0.99f, 1.16f)
                curveToRelative(-0.48f, 2.43f, -2.44f, 4.34f, -4.89f, 4.75f)
                lineTo(12.99f, 21.0f)
                horizontalLineToRelative(7.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(21.99f, 7.0f)
                curveTo(22.0f, 5.9f, 21.1f, 5.0f, 20.0f, 5.0f)
                close()
                moveTo(14.0f, 13.0f)
                curveToRelative(0.0f, 1.1f, -0.9f, 2.0f, -2.0f, 2.0f)
                reflectiveCurveToRelative(-2.0f, -0.9f, -2.0f, -2.0f)
                lineTo(10.0f, 9.0f)
                curveToRelative(0.0f, -1.1f, 0.9f, -2.0f, 2.0f, -2.0f)
                reflectiveCurveToRelative(2.0f, 0.9f, 2.0f, 2.0f)
                verticalLineToRelative(4.0f)
                close()
            }
        }
        return _permCameraMic!!
    }

private var _permCameraMic: ImageVector? = null
