/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.SwapHorizontalCircle: ImageVector
    get() {
        if (_swapHorizontalCircle != null) {
            return _swapHorizontalCircle!!
        }
        _swapHorizontalCircle = materialIcon(name = "Rounded.SwapHorizontalCircle") {
            materialPath {
                moveTo(22.0f, 12.0f)
                curveToRelative(0.0f, -5.52f, -4.48f, -10.0f, -10.0f, -10.0f)
                reflectiveCurveTo(2.0f, 6.48f, 2.0f, 12.0f)
                reflectiveCurveToRelative(4.48f, 10.0f, 10.0f, 10.0f)
                reflectiveCurveToRelative(10.0f, -4.48f, 10.0f, -10.0f)
                close()
                moveTo(15.0f, 6.5f)
                lineToRelative(3.15f, 3.15f)
                curveToRelative(0.2f, 0.2f, 0.2f, 0.51f, 0.0f, 0.71f)
                lineTo(15.0f, 13.5f)
                lineTo(15.0f, 11.0f)
                horizontalLineToRelative(-4.0f)
                lineTo(11.0f, 9.0f)
                horizontalLineToRelative(4.0f)
                lineTo(15.0f, 6.5f)
                close()
                moveTo(9.0f, 17.5f)
                lineToRelative(-3.15f, -3.15f)
                curveToRelative(-0.2f, -0.2f, -0.2f, -0.51f, 0.0f, -0.71f)
                lineTo(9.0f, 10.5f)
                lineTo(9.0f, 13.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(2.0f)
                lineTo(9.0f, 15.0f)
                verticalLineToRelative(2.5f)
                close()
            }
        }
        return _swapHorizontalCircle!!
    }

private var _swapHorizontalCircle: ImageVector? = null
