/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Rounded.Waves: ImageVector
    get() {
        if (_waves != null) {
            return _waves!!
        }
        _waves = materialIcon(name = "Rounded.Waves") {
            materialPath {
                moveTo(17.0f, 16.99f)
                curveToRelative(-1.35f, 0.0f, -2.2f, 0.42f, -2.95f, 0.8f)
                curveToRelative(-0.65f, 0.33f, -1.18f, 0.6f, -2.05f, 0.6f)
                curveToRelative(-0.9f, 0.0f, -1.4f, -0.25f, -2.05f, -0.6f)
                curveToRelative(-0.75f, -0.38f, -1.57f, -0.8f, -2.95f, -0.8f)
                reflectiveCurveToRelative(-2.2f, 0.42f, -2.95f, 0.8f)
                curveToRelative(-0.43f, 0.22f, -0.81f, 0.41f, -1.27f, 0.52f)
                curveToRelative(-0.45f, 0.1f, -0.78f, 0.46f, -0.78f, 0.91f)
                verticalLineToRelative(0.1f)
                curveToRelative(0.0f, 0.6f, 0.56f, 1.03f, 1.14f, 0.91f)
                curveToRelative(0.74f, -0.15f, 1.3f, -0.43f, 1.81f, -0.69f)
                curveToRelative(0.65f, -0.33f, 1.17f, -0.6f, 2.05f, -0.6f)
                reflectiveCurveToRelative(1.4f, 0.25f, 2.05f, 0.6f)
                curveToRelative(0.75f, 0.38f, 1.57f, 0.8f, 2.95f, 0.8f)
                reflectiveCurveToRelative(2.2f, -0.42f, 2.95f, -0.8f)
                curveToRelative(0.65f, -0.33f, 1.18f, -0.6f, 2.05f, -0.6f)
                curveToRelative(0.9f, 0.0f, 1.4f, 0.25f, 2.05f, 0.6f)
                curveToRelative(0.52f, 0.26f, 1.08f, 0.55f, 1.83f, 0.7f)
                curveToRelative(0.58f, 0.11f, 1.12f, -0.33f, 1.12f, -0.91f)
                verticalLineToRelative(-0.09f)
                curveToRelative(0.0f, -0.46f, -0.34f, -0.82f, -0.79f, -0.92f)
                curveToRelative(-0.46f, -0.1f, -0.83f, -0.29f, -1.26f, -0.52f)
                curveToRelative(-0.75f, -0.39f, -1.6f, -0.81f, -2.95f, -0.81f)
                close()
                moveTo(17.0f, 12.54f)
                curveToRelative(-1.35f, 0.0f, -2.2f, 0.43f, -2.95f, 0.8f)
                curveToRelative(-0.65f, 0.32f, -1.18f, 0.6f, -2.05f, 0.6f)
                curveToRelative(-0.9f, 0.0f, -1.4f, -0.25f, -2.05f, -0.6f)
                curveToRelative(-0.75f, -0.38f, -1.57f, -0.8f, -2.95f, -0.8f)
                reflectiveCurveToRelative(-2.2f, 0.43f, -2.95f, 0.8f)
                curveToRelative(-0.43f, 0.21f, -0.81f, 0.41f, -1.28f, 0.52f)
                curveToRelative(-0.44f, 0.1f, -0.77f, 0.46f, -0.77f, 0.91f)
                verticalLineToRelative(0.1f)
                curveToRelative(0.0f, 0.59f, 0.54f, 1.03f, 1.12f, 0.91f)
                curveToRelative(0.75f, -0.15f, 1.31f, -0.44f, 1.83f, -0.69f)
                curveToRelative(0.65f, -0.35f, 1.15f, -0.6f, 2.05f, -0.6f)
                reflectiveCurveToRelative(1.4f, 0.25f, 2.05f, 0.6f)
                curveToRelative(0.75f, 0.38f, 1.57f, 0.8f, 2.95f, 0.8f)
                reflectiveCurveToRelative(2.2f, -0.43f, 2.95f, -0.8f)
                curveToRelative(0.65f, -0.35f, 1.15f, -0.6f, 2.05f, -0.6f)
                reflectiveCurveToRelative(1.4f, 0.25f, 2.05f, 0.6f)
                curveToRelative(0.52f, 0.26f, 1.08f, 0.55f, 1.83f, 0.7f)
                curveToRelative(0.58f, 0.11f, 1.12f, -0.33f, 1.12f, -0.92f)
                verticalLineToRelative(-0.09f)
                curveToRelative(0.0f, -0.46f, -0.34f, -0.82f, -0.79f, -0.92f)
                curveToRelative(-0.46f, -0.1f, -0.83f, -0.29f, -1.26f, -0.52f)
                curveToRelative(-0.75f, -0.38f, -1.6f, -0.8f, -2.95f, -0.8f)
                close()
                moveTo(19.95f, 4.46f)
                curveToRelative(-0.75f, -0.38f, -1.58f, -0.8f, -2.95f, -0.8f)
                reflectiveCurveToRelative(-2.2f, 0.42f, -2.95f, 0.8f)
                curveToRelative(-0.65f, 0.32f, -1.18f, 0.6f, -2.05f, 0.6f)
                curveToRelative(-0.9f, 0.0f, -1.4f, -0.25f, -2.05f, -0.6f)
                curveToRelative(-0.75f, -0.37f, -1.57f, -0.8f, -2.95f, -0.8f)
                reflectiveCurveToRelative(-2.2f, 0.42f, -2.95f, 0.8f)
                curveToRelative(-0.43f, 0.22f, -0.81f, 0.41f, -1.27f, 0.52f)
                curveToRelative(-0.45f, 0.1f, -0.78f, 0.46f, -0.78f, 0.91f)
                verticalLineToRelative(0.07f)
                curveToRelative(0.0f, 0.6f, 0.54f, 1.04f, 1.12f, 0.92f)
                curveToRelative(0.75f, -0.15f, 1.31f, -0.44f, 1.83f, -0.69f)
                curveToRelative(0.65f, -0.33f, 1.17f, -0.6f, 2.05f, -0.6f)
                reflectiveCurveToRelative(1.4f, 0.25f, 2.05f, 0.6f)
                curveToRelative(0.75f, 0.38f, 1.57f, 0.8f, 2.95f, 0.8f)
                reflectiveCurveToRelative(2.2f, -0.43f, 2.95f, -0.8f)
                curveToRelative(0.65f, -0.32f, 1.18f, -0.6f, 2.05f, -0.6f)
                curveToRelative(0.9f, 0.0f, 1.4f, 0.25f, 2.05f, 0.6f)
                curveToRelative(0.52f, 0.26f, 1.08f, 0.55f, 1.83f, 0.7f)
                curveToRelative(0.58f, 0.11f, 1.12f, -0.33f, 1.12f, -0.92f)
                verticalLineToRelative(-0.09f)
                curveToRelative(0.0f, -0.46f, -0.34f, -0.82f, -0.79f, -0.92f)
                curveToRelative(-0.46f, -0.1f, -0.83f, -0.28f, -1.26f, -0.5f)
                close()
                moveTo(17.0f, 8.09f)
                curveToRelative(-1.35f, 0.0f, -2.2f, 0.43f, -2.95f, 0.8f)
                curveToRelative(-0.65f, 0.35f, -1.15f, 0.6f, -2.05f, 0.6f)
                reflectiveCurveToRelative(-1.4f, -0.25f, -2.05f, -0.6f)
                curveToRelative(-0.75f, -0.38f, -1.57f, -0.8f, -2.95f, -0.8f)
                reflectiveCurveToRelative(-2.2f, 0.43f, -2.95f, 0.8f)
                curveToRelative(-0.43f, 0.23f, -0.8f, 0.42f, -1.26f, 0.52f)
                curveToRelative(-0.45f, 0.1f, -0.79f, 0.46f, -0.79f, 0.92f)
                verticalLineToRelative(0.09f)
                curveToRelative(0.0f, 0.59f, 0.54f, 1.03f, 1.12f, 0.91f)
                curveToRelative(0.75f, -0.15f, 1.31f, -0.44f, 1.83f, -0.69f)
                curveToRelative(0.65f, -0.32f, 1.18f, -0.6f, 2.05f, -0.6f)
                reflectiveCurveToRelative(1.4f, 0.25f, 2.05f, 0.6f)
                curveToRelative(0.75f, 0.38f, 1.57f, 0.8f, 2.95f, 0.8f)
                reflectiveCurveToRelative(2.2f, -0.43f, 2.95f, -0.8f)
                curveToRelative(0.65f, -0.32f, 1.18f, -0.6f, 2.05f, -0.6f)
                curveToRelative(0.9f, 0.0f, 1.4f, 0.25f, 2.05f, 0.6f)
                curveToRelative(0.52f, 0.26f, 1.08f, 0.55f, 1.83f, 0.7f)
                curveToRelative(0.58f, 0.11f, 1.12f, -0.33f, 1.12f, -0.91f)
                verticalLineToRelative(-0.09f)
                curveToRelative(0.0f, -0.46f, -0.34f, -0.82f, -0.79f, -0.92f)
                curveToRelative(-0.46f, -0.1f, -0.83f, -0.29f, -1.26f, -0.52f)
                curveToRelative(-0.75f, -0.39f, -1.6f, -0.81f, -2.95f, -0.81f)
                close()
            }
        }
        return _waves!!
    }

private var _waves: ImageVector? = null
