/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FileCopy: ImageVector
    get() {
        if (_fileCopy != null) {
            return _fileCopy!!
        }
        _fileCopy = materialIcon(name = "Sharp.FileCopy") {
            materialPath {
                moveTo(16.0f, 1.0f)
                lineTo(2.0f, 1.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(2.0f)
                lineTo(4.0f, 3.0f)
                horizontalLineToRelative(12.0f)
                lineTo(16.0f, 1.0f)
                close()
                moveTo(15.0f, 5.0f)
                lineToRelative(6.0f, 6.0f)
                verticalLineToRelative(12.0f)
                lineTo(6.0f, 23.0f)
                lineTo(6.0f, 5.0f)
                horizontalLineToRelative(9.0f)
                close()
                moveTo(14.0f, 12.0f)
                horizontalLineToRelative(5.5f)
                lineTo(14.0f, 6.5f)
                lineTo(14.0f, 12.0f)
                close()
            }
        }
        return _fileCopy!!
    }

private var _fileCopy: ImageVector? = null
