/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Sharp.FlipCameraIos: ImageVector
    get() {
        if (_flipCameraIos != null) {
            return _flipCameraIos!!
        }
        _flipCameraIos = materialIcon(name = "Sharp.FlipCameraIos") {
            materialPath {
                moveTo(16.83f, 5.0f)
                lineTo(15.0f, 3.0f)
                horizontalLineTo(9.0f)
                lineTo(7.17f, 5.0f)
                horizontalLineTo(2.0f)
                verticalLineToRelative(16.0f)
                horizontalLineToRelative(20.0f)
                verticalLineTo(5.0f)
                horizontalLineTo(16.83f)
                close()
                moveTo(12.0f, 18.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                horizontalLineTo(5.0f)
                lineToRelative(2.5f, -2.5f)
                lineTo(10.0f, 13.0f)
                horizontalLineTo(8.0f)
                curveToRelative(0.0f, 2.21f, 1.79f, 4.0f, 4.0f, 4.0f)
                curveToRelative(0.58f, 0.0f, 1.13f, -0.13f, 1.62f, -0.35f)
                lineToRelative(0.74f, 0.74f)
                curveTo(13.65f, 17.76f, 12.86f, 18.0f, 12.0f, 18.0f)
                close()
                moveTo(16.5f, 15.5f)
                lineTo(14.0f, 13.0f)
                horizontalLineToRelative(2.0f)
                curveToRelative(0.0f, -2.21f, -1.79f, -4.0f, -4.0f, -4.0f)
                curveToRelative(-0.58f, 0.0f, -1.13f, 0.13f, -1.62f, 0.35f)
                lineTo(9.64f, 8.62f)
                curveTo(10.35f, 8.24f, 11.14f, 8.0f, 12.0f, 8.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, 2.24f, 5.0f, 5.0f)
                horizontalLineToRelative(2.0f)
                lineTo(16.5f, 15.5f)
                close()
            }
        }
        return _flipCameraIos!!
    }

private var _flipCameraIos: ImageVector? = null
