/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.twotone

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.TwoTone.SoupKitchen: ImageVector
    get() {
        if (_soupKitchen != null) {
            return _soupKitchen!!
        }
        _soupKitchen = materialIcon(name = "TwoTone.SoupKitchen") {
            materialPath(fillAlpha = 0.3f, strokeAlpha = 0.3f) {
                moveTo(14.12f, 17.0f)
                curveToRelative(-0.73f, 1.78f, -2.43f, 3.0f, -4.37f, 3.0f)
                curveToRelative(-1.94f, 0.0f, -3.67f, -1.23f, -4.43f, -3.0f)
                horizontalLineToRelative(8.78f)
            }
            materialPath {
                moveTo(6.4f, 7.0f)
                curveTo(6.06f, 7.55f, 6.0f, 7.97f, 6.0f, 8.38f)
                curveTo(6.0f, 9.15f, 7.0f, 11.0f, 7.0f, 12.0f)
                curveToRelative(0.0f, 0.95f, -0.4f, 1.5f, -0.4f, 1.5f)
                horizontalLineTo(5.1f)
                curveToRelative(0.0f, 0.0f, 0.4f, -0.55f, 0.4f, -1.5f)
                curveToRelative(0.0f, -1.0f, -1.0f, -2.85f, -1.0f, -3.62f)
                curveTo(4.5f, 7.97f, 4.56f, 7.55f, 4.9f, 7.0f)
                horizontalLineTo(6.4f)
                close()
                moveTo(11.4f, 7.0f)
                curveTo(11.06f, 7.55f, 11.0f, 7.97f, 11.0f, 8.38f)
                curveTo(11.0f, 9.15f, 12.0f, 11.0f, 12.0f, 12.0f)
                curveToRelative(0.0f, 0.95f, -0.4f, 1.5f, -0.4f, 1.5f)
                horizontalLineToRelative(1.5f)
                curveToRelative(0.0f, 0.0f, 0.4f, -0.55f, 0.4f, -1.5f)
                curveToRelative(0.0f, -1.0f, -1.0f, -2.85f, -1.0f, -3.62f)
                curveToRelative(0.0f, -0.41f, 0.06f, -0.83f, 0.4f, -1.38f)
                horizontalLineTo(11.4f)
                close()
                moveTo(8.15f, 7.0f)
                curveToRelative(-0.34f, 0.55f, -0.4f, 0.97f, -0.4f, 1.38f)
                curveToRelative(0.0f, 0.77f, 1.0f, 2.63f, 1.0f, 3.62f)
                curveToRelative(0.0f, 0.95f, -0.4f, 1.5f, -0.4f, 1.5f)
                horizontalLineToRelative(1.5f)
                curveToRelative(0.0f, 0.0f, 0.4f, -0.55f, 0.4f, -1.5f)
                curveToRelative(0.0f, -1.0f, -1.0f, -2.85f, -1.0f, -3.62f)
                curveToRelative(0.0f, -0.41f, 0.06f, -0.83f, 0.4f, -1.38f)
                horizontalLineTo(8.15f)
                close()
                moveTo(18.6f, 2.0f)
                curveToRelative(-1.54f, 0.0f, -2.81f, 1.16f, -2.98f, 2.65f)
                lineTo(14.53f, 15.0f)
                horizontalLineTo(4.01f)
                curveToRelative(-0.6f, 0.0f, -1.09f, 0.53f, -1.0f, 1.13f)
                curveTo(3.53f, 19.46f, 6.39f, 22.0f, 9.75f, 22.0f)
                curveToRelative(3.48f, 0.0f, 6.34f, -2.73f, 6.71f, -6.23f)
                lineToRelative(1.15f, -10.87f)
                curveTo(17.66f, 4.39f, 18.08f, 4.0f, 18.6f, 4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                curveToRelative(0.0f, 0.3f, -0.1f, 1.25f, -0.1f, 1.25f)
                lineToRelative(1.97f, 0.25f)
                curveToRelative(0.0f, 0.0f, 0.13f, -1.06f, 0.13f, -1.5f)
                curveTo(21.6f, 3.35f, 20.25f, 2.0f, 18.6f, 2.0f)
                close()
                moveTo(9.75f, 20.0f)
                curveToRelative(-1.94f, 0.0f, -3.67f, -1.23f, -4.43f, -3.0f)
                horizontalLineToRelative(8.78f)
                horizontalLineToRelative(0.01f)
                curveTo(13.39f, 18.78f, 11.69f, 20.0f, 9.75f, 20.0f)
                close()
            }
        }
        return _soupKitchen!!
    }

private var _soupKitchen: ImageVector? = null
