/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.rounded

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Rounded.ScheduleSend: ImageVector
    get() {
        if (_scheduleSend != null) {
            return _scheduleSend!!
        }
        _scheduleSend = materialIcon(name = "AutoMirrored.Rounded.ScheduleSend", autoMirror =
                true) {
            materialPath {
                moveTo(17.0f, 10.0f)
                curveToRelative(0.1f, 0.0f, 0.19f, 0.01f, 0.28f, 0.01f)
                lineTo(4.39f, 4.58f)
                curveTo(3.73f, 4.31f, 3.0f, 4.79f, 3.0f, 5.51f)
                verticalLineToRelative(3.71f)
                curveToRelative(0.0f, 0.46f, 0.31f, 0.86f, 0.76f, 0.97f)
                lineTo(11.0f, 12.0f)
                lineToRelative(-7.24f, 1.81f)
                curveTo(3.31f, 13.92f, 3.0f, 14.32f, 3.0f, 14.78f)
                verticalLineToRelative(3.71f)
                curveToRelative(0.0f, 0.72f, 0.73f, 1.2f, 1.39f, 0.92f)
                lineTo(10.0f, 17.05f)
                curveToRelative(0.0f, -0.02f, 0.0f, -0.03f, 0.0f, -0.05f)
                curveTo(10.0f, 13.14f, 13.14f, 10.0f, 17.0f, 10.0f)
                close()
            }
            materialPath {
                moveTo(17.0f, 12.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, 2.24f, -5.0f, 5.0f)
                reflectiveCurveToRelative(2.24f, 5.0f, 5.0f, 5.0f)
                curveToRelative(2.76f, 0.0f, 5.0f, -2.24f, 5.0f, -5.0f)
                reflectiveCurveTo(19.76f, 12.0f, 17.0f, 12.0f)
                close()
                moveTo(18.29f, 19.0f)
                lineToRelative(-1.65f, -1.65f)
                curveToRelative(-0.09f, -0.09f, -0.15f, -0.22f, -0.15f, -0.35f)
                verticalLineToRelative(-2.5f)
                curveToRelative(0.0f, -0.28f, 0.22f, -0.5f, 0.5f, -0.5f)
                horizontalLineToRelative(0.0f)
                curveToRelative(0.28f, 0.0f, 0.5f, 0.22f, 0.5f, 0.5f)
                verticalLineToRelative(2.29f)
                lineToRelative(1.5f, 1.5f)
                curveToRelative(0.2f, 0.2f, 0.2f, 0.51f, 0.0f, 0.71f)
                lineToRelative(0.0f, 0.0f)
                curveTo(18.8f, 19.2f, 18.49f, 19.2f, 18.29f, 19.0f)
                close()
            }
        }
        return _scheduleSend!!
    }

private var _scheduleSend: ImageVector? = null
