/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.automirrored.sharp

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.AutoMirrored.Sharp.StopScreenShare: ImageVector
    get() {
        if (_stopScreenShare != null) {
            return _stopScreenShare!!
        }
        _stopScreenShare = materialIcon(name = "AutoMirrored.Sharp.StopScreenShare", autoMirror =
                true) {
            materialPath {
                moveTo(21.79f, 18.0f)
                lineToRelative(2.0f, 2.0f)
                lineTo(24.0f, 20.0f)
                verticalLineToRelative(-2.0f)
                close()
                moveTo(13.0f, 9.13f)
                lineTo(13.0f, 7.0f)
                lineToRelative(4.0f, 3.74f)
                lineToRelative(-1.28f, 1.19f)
                lineToRelative(5.18f, 5.18f)
                lineTo(22.0f, 16.0f)
                lineTo(22.0f, 4.02f)
                lineTo(7.8f, 4.02f)
                lineToRelative(5.13f, 5.13f)
                curveToRelative(0.03f, -0.01f, 0.05f, -0.02f, 0.07f, -0.02f)
                close()
                moveTo(1.11f, 2.98f)
                lineToRelative(0.89f, 0.9f)
                verticalLineToRelative(12.14f)
                lineToRelative(2.0f, 1.99f)
                lineTo(0.0f, 18.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(18.13f)
                lineToRelative(2.71f, 2.71f)
                lineToRelative(1.41f, -1.41f)
                lineTo(2.52f, 1.57f)
                lineTo(1.11f, 2.98f)
                close()
                moveTo(9.08f, 10.95f)
                lineToRelative(1.59f, 1.59f)
                curveTo(9.13f, 12.92f, 7.96f, 13.71f, 7.0f, 15.0f)
                curveToRelative(0.31f, -1.48f, 0.94f, -2.93f, 2.08f, -4.05f)
                close()
            }
        }
        return _stopScreenShare!!
    }

private var _stopScreenShare: ImageVector? = null
