/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.AddModerator: ImageVector
    get() {
        if (_addModerator != null) {
            return _addModerator!!
        }
        _addModerator = materialIcon(name = "Filled.AddModerator") {
            materialPath {
                moveTo(13.22f, 22.61f)
                curveToRelative(-0.4f, 0.15f, -0.8f, 0.29f, -1.22f, 0.39f)
                curveToRelative(-5.16f, -1.26f, -9.0f, -6.45f, -9.0f, -12.0f)
                verticalLineTo(5.0f)
                lineToRelative(9.0f, -4.0f)
                lineToRelative(9.0f, 4.0f)
                verticalLineToRelative(6.0f)
                curveToRelative(0.0f, 0.9f, -0.11f, 1.78f, -0.3f, 2.65f)
                curveToRelative(-0.81f, -0.41f, -1.73f, -0.65f, -2.7f, -0.65f)
                curveToRelative(-3.31f, 0.0f, -6.0f, 2.69f, -6.0f, 6.0f)
                curveToRelative(0.0f, 1.36f, 0.46f, 2.61f, 1.22f, 3.61f)
                close()
                moveTo(19.0f, 20.0f)
                verticalLineToRelative(2.99f)
                reflectiveCurveToRelative(-1.99f, 0.01f, -2.0f, 0.0f)
                verticalLineTo(20.0f)
                horizontalLineToRelative(-3.0f)
                verticalLineToRelative(-2.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(-3.0f)
                horizontalLineToRelative(2.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(3.0f)
                verticalLineToRelative(2.0f)
                horizontalLineToRelative(-3.0f)
                close()
            }
        }
        return _addModerator!!
    }

private var _addModerator: ImageVector? = null
