/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.GTranslate: ImageVector
    get() {
        if (_gTranslate != null) {
            return _gTranslate!!
        }
        _gTranslate = materialIcon(name = "Filled.GTranslate") {
            materialPath {
                moveTo(21.0f, 4.0f)
                lineTo(11.0f, 4.0f)
                lineToRelative(-1.0f, -3.0f)
                lineTo(3.0f, 1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, 0.9f, -2.0f, 2.0f)
                verticalLineToRelative(15.0f)
                curveToRelative(0.0f, 1.1f, 0.9f, 2.0f, 2.0f, 2.0f)
                horizontalLineToRelative(8.0f)
                lineToRelative(1.0f, 3.0f)
                horizontalLineToRelative(9.0f)
                curveToRelative(1.1f, 0.0f, 2.0f, -0.9f, 2.0f, -2.0f)
                lineTo(23.0f, 6.0f)
                curveToRelative(0.0f, -1.1f, -0.9f, -2.0f, -2.0f, -2.0f)
                close()
                moveTo(7.0f, 16.0f)
                curveToRelative(-2.76f, 0.0f, -5.0f, -2.24f, -5.0f, -5.0f)
                reflectiveCurveToRelative(2.24f, -5.0f, 5.0f, -5.0f)
                curveToRelative(1.35f, 0.0f, 2.48f, 0.5f, 3.35f, 1.3f)
                lineTo(9.03f, 8.57f)
                curveToRelative(-0.38f, -0.36f, -1.04f, -0.78f, -2.03f, -0.78f)
                curveToRelative(-1.74f, 0.0f, -3.15f, 1.44f, -3.15f, 3.21f)
                reflectiveCurveTo(5.26f, 14.21f, 7.0f, 14.21f)
                curveToRelative(2.01f, 0.0f, 2.84f, -1.44f, 2.92f, -2.41f)
                lineTo(7.0f, 11.8f)
                verticalLineToRelative(-1.71f)
                horizontalLineToRelative(4.68f)
                curveToRelative(0.07f, 0.31f, 0.12f, 0.61f, 0.12f, 1.02f)
                curveTo(11.8f, 13.97f, 9.89f, 16.0f, 7.0f, 16.0f)
                close()
                moveTo(13.17f, 10.58f)
                horizontalLineToRelative(3.7f)
                curveToRelative(-0.43f, 1.25f, -1.11f, 2.43f, -2.05f, 3.47f)
                curveToRelative(-0.31f, -0.35f, -0.6f, -0.72f, -0.86f, -1.1f)
                lineToRelative(-0.79f, -2.37f)
                close()
                moveTo(21.5f, 20.5f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                lineTo(14.0f, 21.5f)
                lineToRelative(2.0f, -2.5f)
                lineToRelative(-1.04f, -3.1f)
                lineToRelative(3.1f, 3.1f)
                lineToRelative(0.92f, -0.92f)
                lineToRelative(-3.3f, -3.25f)
                lineToRelative(0.02f, -0.02f)
                curveToRelative(1.13f, -1.25f, 1.93f, -2.69f, 2.4f, -4.22f)
                lineTo(20.0f, 10.59f)
                verticalLineToRelative(-1.3f)
                horizontalLineToRelative(-4.53f)
                lineTo(15.47f, 8.0f)
                horizontalLineToRelative(-1.29f)
                verticalLineToRelative(1.29f)
                horizontalLineToRelative(-1.44f)
                lineTo(11.46f, 5.5f)
                horizontalLineToRelative(9.04f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(14.0f)
                close()
            }
        }
        return _gTranslate!!
    }

private var _gTranslate: ImageVector? = null
