/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.filled

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Filled.PrintDisabled: ImageVector
    get() {
        if (_printDisabled != null) {
            return _printDisabled!!
        }
        _printDisabled = materialIcon(name = "Filled.PrintDisabled") {
            materialPath {
                moveTo(19.1f, 17.0f)
                lineTo(22.0f, 17.0f)
                verticalLineToRelative(-6.0f)
                curveToRelative(0.0f, -1.7f, -1.3f, -3.0f, -3.0f, -3.0f)
                horizontalLineToRelative(-9.0f)
                lineToRelative(9.1f, 9.0f)
                close()
                moveTo(19.0f, 10.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                reflectiveCurveToRelative(-0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                reflectiveCurveToRelative(0.45f, -1.0f, 1.0f, -1.0f)
                close()
                moveTo(18.0f, 7.0f)
                lineTo(18.0f, 3.0f)
                lineTo(6.0f, 3.0f)
                verticalLineToRelative(1.1f)
                lineTo(9.0f, 7.0f)
                close()
                moveTo(1.2f, 1.8f)
                lineTo(0.0f, 3.0f)
                lineToRelative(4.9f, 5.0f)
                curveTo(3.3f, 8.1f, 2.0f, 9.4f, 2.0f, 11.0f)
                verticalLineToRelative(6.0f)
                horizontalLineToRelative(4.0f)
                verticalLineToRelative(4.0f)
                horizontalLineToRelative(11.9f)
                lineToRelative(3.0f, 3.0f)
                lineToRelative(1.3f, -1.3f)
                lineToRelative(-21.0f, -20.9f)
                close()
                moveTo(8.0f, 19.0f)
                verticalLineToRelative(-5.0f)
                horizontalLineToRelative(2.9f)
                lineToRelative(5.0f, 5.0f)
                lineTo(8.0f, 19.0f)
                close()
            }
        }
        return _printDisabled!!
    }

private var _printDisabled: ImageVector? = null
