/*
 * Copyright 2023 The Android Open Source Project
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package androidx.compose.material.icons.outlined

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.materialIcon
import androidx.compose.material.icons.materialPath
import androidx.compose.ui.graphics.vector.ImageVector

public val Icons.Outlined.NoLuggage: ImageVector
    get() {
        if (_noLuggage != null) {
            return _noLuggage!!
        }
        _noLuggage = materialIcon(name = "Outlined.NoLuggage") {
            materialPath {
                moveTo(16.0f, 13.17f)
                lineToRelative(-1.5f, -1.5f)
                verticalLineTo(9.0f)
                horizontalLineTo(16.0f)
                verticalLineTo(13.17f)
                close()
                moveTo(19.78f, 22.61f)
                lineToRelative(-1.85f, -1.85f)
                curveTo(17.65f, 20.91f, 17.34f, 21.0f, 17.0f, 21.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                reflectiveCurveToRelative(-1.0f, -0.45f, -1.0f, -1.0f)
                horizontalLineTo(9.0f)
                curveToRelative(0.0f, 0.55f, -0.45f, 1.0f, -1.0f, 1.0f)
                curveToRelative(-0.55f, 0.0f, -1.0f, -0.45f, -1.0f, -1.0f)
                curveToRelative(-1.1f, 0.0f, -2.0f, -0.9f, -2.0f, -2.0f)
                verticalLineTo(8.0f)
                curveToRelative(0.0f, -0.05f, 0.02f, -0.1f, 0.02f, -0.15f)
                lineTo(1.39f, 4.22f)
                lineToRelative(1.41f, -1.41f)
                lineToRelative(18.38f, 18.38f)
                lineTo(19.78f, 22.61f)
                close()
                moveTo(16.17f, 19.0f)
                lineToRelative(-3.42f, -3.42f)
                verticalLineTo(18.0f)
                horizontalLineToRelative(-1.5f)
                verticalLineToRelative(-3.92f)
                lineTo(9.5f, 12.33f)
                verticalLineTo(18.0f)
                horizontalLineTo(8.0f)
                verticalLineToRelative(-7.17f)
                lineToRelative(-1.0f, -1.0f)
                verticalLineTo(19.0f)
                horizontalLineTo(16.17f)
                close()
                moveTo(12.75f, 9.0f)
                horizontalLineToRelative(-0.92f)
                lineToRelative(0.92f, 0.92f)
                verticalLineTo(9.0f)
                close()
                moveTo(19.0f, 8.0f)
                verticalLineToRelative(8.17f)
                lineToRelative(-2.0f, -2.0f)
                verticalLineTo(8.0f)
                horizontalLineToRelative(-6.17f)
                lineTo(9.84f, 7.01f)
                lineTo(9.0f, 6.17f)
                verticalLineTo(6.0f)
                verticalLineTo(3.0f)
                curveToRelative(0.0f, -0.55f, 0.45f, -1.0f, 1.0f, -1.0f)
                horizontalLineToRelative(4.0f)
                curveToRelative(0.55f, 0.0f, 1.0f, 0.45f, 1.0f, 1.0f)
                verticalLineToRelative(3.0f)
                horizontalLineToRelative(2.0f)
                curveTo(18.1f, 6.0f, 19.0f, 6.9f, 19.0f, 8.0f)
                close()
                moveTo(10.5f, 6.0f)
                horizontalLineToRelative(3.0f)
                verticalLineTo(3.5f)
                horizontalLineToRelative(-3.0f)
                verticalLineTo(6.0f)
                close()
            }
        }
        return _noLuggage!!
    }

private var _noLuggage: ImageVector? = null
